/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.requests;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.query.CouchViewQuery;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.QueryResult;
import org.tiogasolutions.push.kernel.system.DomainSpecificStore;
import org.tiogasolutions.push.pub.common.PushType;

@Component
public class PushRequestStore
extends DomainSpecificStore<PushRequest> {
    public static final String PUSH_REQUEST_DESIGN_NAME = "push-request";

    @Autowired
    public PushRequestStore(ExecutionManager executionManager) {
        super(executionManager, PushRequest.class);
    }

    public PushRequest getByPushRequestId(String pushRequestId) {
        return (PushRequest)super.getByDocumentId(pushRequestId);
    }

    public QueryResult<PushRequest> getByClient(DomainProfileEntity domain, int limit) {
        CouchViewQuery viewQuery = CouchViewQuery.builder((String)this.getDesignName(), (String)"byClient").limit(limit).key(new Object[]{domain.getDomainId()}).build();
        return new QueryResult<PushRequest>(PushRequest.class, this.getDatabase(), viewQuery);
    }

    public List<PushRequest> getByClientAndType(DomainProfileEntity domain, PushType type) {
        return super.getEntities("byClientAndType", new String[]{domain.getDomainId(), type.getCode()});
    }

    public List<PushRequest> getByClientAndSession(DomainProfileEntity domain, String sessionId) {
        return super.getEntities("byClientAndSession", new String[]{domain.getDomainId(), sessionId});
    }

    public List<PushRequest> getByClientAndDevice(DomainProfileEntity domain, String deviceId) {
        return super.getEntities("byClientAndDevice", new String[]{domain.getDomainId(), deviceId});
    }

    public String getDesignName() {
        return PUSH_REQUEST_DESIGN_NAME;
    }
}

