/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.requests;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.DateUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.pub.SesEmailPush;
import org.tiogasolutions.push.pub.SmtpEmailPush;
import org.tiogasolutions.push.pub.common.CommonEmail;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.PushTraits;
import org.tiogasolutions.push.pub.common.PushType;
import org.tiogasolutions.push.pub.common.RequestStatus;
import org.tiogasolutions.push.pub.internal.CpIdGenerator;

@CouchEntity(value="push-request")
public class PushRequest
implements Comparable<PushRequest> {
    private final String pushRequestId;
    private final String revision;
    private final int apiVersion;
    private final String domainId;
    private final String domainKey;
    private final LocalDateTime createdAt;
    private RequestStatus requestStatus;
    private final String remoteHost;
    private final String remoteAddress;
    private final PushType pushType;
    private final List<String> notes = new ArrayList<String>();
    private final Push push;

    @JsonCreator
    private PushRequest(@JacksonInject(value="pushRequestId") String pushRequestId, @JacksonInject(value="revision") String revision, @JsonProperty(value="apiVersion") int apiVersion, @JsonProperty(value="domainId") String domainId, @JsonProperty(value="domainKey") String domainKey, @JsonProperty(value="createdAt") LocalDateTime createdAt, @JsonProperty(value="requestStatus") RequestStatus requestStatus, @JsonProperty(value="remoteHost") String remoteHost, @JsonProperty(value="remoteAddress") String remoteAddress, @JsonProperty(value="pushType") PushType pushType, @JsonProperty(value="notes") List<String> notes, @JsonProperty(value="push") Push push) {
        this.pushRequestId = pushRequestId;
        this.revision = revision;
        this.apiVersion = apiVersion;
        this.domainId = domainId;
        this.domainKey = domainKey;
        this.createdAt = createdAt;
        this.requestStatus = requestStatus;
        this.remoteHost = remoteHost;
        this.remoteAddress = remoteAddress;
        this.pushType = pushType;
        this.notes.addAll(notes);
        this.push = push;
    }

    public PushRequest(int apiVersion, DomainProfileEntity domain, Push push) {
        this.pushRequestId = CpIdGenerator.newId();
        this.revision = null;
        this.apiVersion = apiVersion;
        this.domainId = domain.getDomainId();
        this.domainKey = domain.getDomainKey();
        this.createdAt = DateUtils.currentLocalDateTime();
        this.requestStatus = RequestStatus.pending;
        this.remoteHost = push.getRemoteHost();
        this.remoteAddress = push.getRemoteAddress();
        this.pushType = push.getPushType();
        this.push = push;
    }

    @CouchId
    public String getPushRequestId() {
        return this.pushRequestId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public String getDomainKey() {
        return this.domainKey;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public PushType getPushType() {
        return this.pushType;
    }

    public String getCreatedAt(String format) {
        return this.createdAt == null ? null : this.createdAt.format(DateTimeFormatter.ofPattern(format));
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public List<String> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    public void addNote(String note) {
        this.notes.add(note);
    }

    public RequestStatus processed() {
        return this.processed(null);
    }

    public RequestStatus processed(String note) {
        this.requestStatus = RequestStatus.processed;
        this.notes.add("Request has been processed.");
        if (StringUtils.isNotBlank((Object)note)) {
            this.notes.add(note);
        }
        return this.requestStatus;
    }

    public RequestStatus denyRequest(String reasonNotPermitted) {
        this.requestStatus = RequestStatus.denied;
        this.notes.add("Request denied: " + reasonNotPermitted);
        return this.requestStatus;
    }

    public RequestStatus failed(String message) {
        this.requestStatus = RequestStatus.failed;
        if (StringUtils.isBlank((Object)message)) {
            this.notes.add("*** FAILURE - Reason unspecified **");
        } else {
            this.notes.add("*** FAILURE ***");
            this.notes.add(message);
        }
        return this.requestStatus;
    }

    public RequestStatus failed(Exception ex) {
        this.requestStatus = RequestStatus.failed;
        this.notes.add("*** FAILURE ***");
        for (Throwable throwable : ExceptionUtils.getRootCauses((Throwable)ex)) {
            this.notes.add(ExceptionUtils.getMessage((Throwable)throwable));
        }
        return this.requestStatus;
    }

    public RequestStatus warn(String message) {
        this.requestStatus = RequestStatus.warning;
        if (StringUtils.isBlank((Object)message)) {
            this.notes.add("*** WARNING - Reason unspecified **");
        } else {
            this.notes.add("*** WARNING ***");
            this.notes.add(message);
        }
        return this.requestStatus;
    }

    public RequestStatus warn(Throwable e) {
        this.requestStatus = RequestStatus.warning;
        this.notes.add("*** WARNING ***");
        for (Throwable throwable : ExceptionUtils.getRootCauses((Throwable)e)) {
            this.notes.add(ExceptionUtils.getMessage((Throwable)throwable));
        }
        return this.requestStatus;
    }

    public Push getPush() {
        return this.push;
    }

    @JsonIgnore
    public SesEmailPush getSesEmailPush() {
        return this.push instanceof SesEmailPush ? (SesEmailPush)this.push : null;
    }

    @JsonIgnore
    public SmtpEmailPush getSmtpEmailPush() {
        return this.push instanceof SmtpEmailPush ? (SmtpEmailPush)this.push : null;
    }

    @JsonIgnore
    public CommonEmail getCommonEmail() {
        return this.push instanceof CommonEmail ? (CommonEmail)this.push : null;
    }

    public boolean equals(Object object) {
        if (object instanceof PushRequest) {
            PushRequest that = (PushRequest)object;
            return this.pushRequestId.equals(that.pushRequestId);
        }
        return false;
    }

    @Override
    public int compareTo(PushRequest that) {
        return this.createdAt.compareTo(that.createdAt);
    }

    public String toString() {
        return this.push.getPushType().getLabel() + ": " + this.push.toString();
    }

    @JsonIgnore
    public PushTraits getPushTraits() {
        return new PushTraits(this.pushRequestId, this.domainKey, this.push.getTraits());
    }
}

