/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.execution;

import javax.ws.rs.core.UriInfo;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.config.CouchServersConfig;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.plugins.PushProcessor;
import org.tiogasolutions.push.kernel.system.PluginManager;

@Component
public class ExecutionManager
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private final InheritableThreadLocal<ExecutionContext> threadLocal = new InheritableThreadLocal();

    public void removeExecutionContext() {
        this.threadLocal.remove();
    }

    public ExecutionContext newContext(UriInfo uriInfo) {
        ExecutionContext context = new ExecutionContext(uriInfo, this.getPushProcessor(), this.getDomainStore());
        this.assignContext(context);
        return context;
    }

    public void assignContext(ExecutionContext context) {
        this.threadLocal.set(context);
    }

    public boolean hasContext() {
        ExecutionContext executionContext = (ExecutionContext)this.threadLocal.get();
        return executionContext != null;
    }

    public ExecutionContext getContext() {
        ExecutionContext context = (ExecutionContext)this.threadLocal.get();
        if (context == null) {
            throw ApiException.internalServerError((String)"There is no current execution getContext for this thread.", (String[])new String[0]);
        }
        return context;
    }

    public CouchServersConfig getCouchServersConfig() {
        return (CouchServersConfig)this.beanFactory.getBean(CouchServersConfig.class);
    }

    public CouchServer getCouchServer() {
        return (CouchServer)this.beanFactory.getBean(CouchServer.class);
    }

    public PushProcessor getPushProcessor() {
        return (PushProcessor)this.beanFactory.getBean(PushProcessor.class);
    }

    public DomainStore getDomainStore() {
        return (DomainStore)((Object)this.beanFactory.getBean(DomainStore.class));
    }

    public PluginManager getPluginManager() {
        return (PluginManager)this.beanFactory.getBean(PluginManager.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

