/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.execution;

import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.plugins.PushProcessor;
import org.tiogasolutions.push.kernel.system.Session;

public class ExecutionContext {
    private Session session;
    private Account account;
    private DomainProfileEntity domain;
    private final UriInfo uriInfo;
    private final PushProcessor pushProcessor;
    private final DomainStore domainStore;

    public ExecutionContext(UriInfo uriInfo, PushProcessor pushProcessor, DomainStore domainStore) {
        this.uriInfo = uriInfo;
        this.domainStore = domainStore;
        this.pushProcessor = pushProcessor;
    }

    public PushProcessor getPushProcessor() {
        return this.pushProcessor;
    }

    public DomainStore getDomainStore() {
        return this.domainStore;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session != null ? this.session : new Session(-1L, "dummy-session");
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setDomain(DomainProfileEntity domain) {
        this.domain = domain;
    }

    public DomainProfileEntity getDomain() {
        return this.domain;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setLastMessage(String message) {
        if (this.session != null) {
            this.session.setLastMessage(message);
        }
    }
}

