/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.actions;

import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidatableAction;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class UpdateDomainAction
implements ValidatableAction {
    private final String domainKey;
    private final String domainPassword;
    private final int retentionDays;

    public UpdateDomainAction(String domainKey, String domainPassword, int retentionDays) {
        this.domainKey = domainKey;
        this.domainPassword = domainPassword;
        this.retentionDays = retentionDays < 0 ? 0 : retentionDays;
    }

    public String getDomainKey() {
        return this.domainKey;
    }

    public String getDomainPassword() {
        return this.domainPassword;
    }

    public int getRetentionDays() {
        return this.retentionDays;
    }

    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.validateUserName((RequestErrors)errors, (String)this.domainKey, (String)"domain's key");
        ValidationUtils.validatePassword((RequestErrors)errors, (String)this.domainPassword, (String)"domain's password");
        return errors;
    }
}

