/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.actions;

import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidatableAction;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class CreateDomainAction
implements ValidatableAction {
    private final String accountId;
    private final String domainKey;
    private final String domainPassword;

    public CreateDomainAction(Account account, String domainKey, String domainPassword) {
        this.accountId = account.getAccountId();
        this.domainKey = domainKey;
        this.domainPassword = domainPassword;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getDomainKey() {
        return this.domainKey;
    }

    public String getDomainPassword() {
        return this.domainPassword;
    }

    public RequestErrors validate(RequestErrors errors) {
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.accountId, (String)"The accountId must be specified.");
        ValidationUtils.validateUserName((RequestErrors)errors, (String)this.domainKey, (String)"domain's key");
        ValidationUtils.validatePassword((RequestErrors)errors, (String)this.domainPassword, (String)"domain's password");
        return errors;
    }
}

