/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.accounts.actions;

import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.kernel.accounts.actions.AccountAction;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class UpdateAccountAction
extends AccountAction {
    private final String emailAddress;
    private final String firstName;
    private final String lastName;

    public UpdateAccountAction(String firstName, String lastName, String emailAddress) {
        this.emailAddress = StringUtils.emptyToNull((Object)emailAddress);
        this.firstName = StringUtils.emptyToNull((Object)firstName);
        this.lastName = StringUtils.emptyToNull((Object)lastName);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public RequestErrors validate(RequestErrors errors) throws ApiException {
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.firstName, (String)"Your first name must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.lastName, (String)"Your last name must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.emailAddress, (String)"Your email address must be specified.");
        return errors;
    }
}

