/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.accounts.actions;

import java.time.ZoneId;
import java.util.Arrays;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.kernel.accounts.actions.AccountAction;
import org.tiogasolutions.push.pub.internal.RequestErrors;
import org.tiogasolutions.push.pub.internal.ValidationUtils;

public class CreateAccountAction
extends AccountAction {
    private final ZoneId timeZone;
    private final String emailAddress;
    private final String firstName;
    private final String lastName;
    private final String password;
    private final String passwordConfirmed;

    public CreateAccountAction(ZoneId timeZone, String emailAddress, String firstName, String lastName, String password, String passwordConfirmed) {
        this.timeZone = timeZone;
        this.emailAddress = emailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
        this.password = password;
        this.passwordConfirmed = passwordConfirmed;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordConfirmed() {
        return this.passwordConfirmed;
    }

    public RequestErrors validate(RequestErrors errors) throws ApiException {
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.timeZone, (String)"The time zone must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.firstName, (String)"Your first name must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.lastName, (String)"Your last name must be specified.");
        ValidationUtils.requireValue((RequestErrors)errors, (Object)this.emailAddress, (String)"Your email address must be specified.");
        for (String chr : Arrays.asList("<", ">")) {
            if (this.emailAddress == null || !this.emailAddress.contains("<")) continue;
            String msg = String.format("Your email address must not contain the \"%s\" character.", chr);
            errors.add((Object)msg);
        }
        return errors;
    }
}

