/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.tiogasolutions.push.kernel.accounts.EcsPermission;

public class Permissions
implements Serializable {
    private Set<String> roleTypes = new HashSet<String>();

    public Permissions() {
    }

    public Permissions(Set<String> roleTypes) {
        if (roleTypes != null) {
            this.roleTypes.addAll(roleTypes);
        }
    }

    public Set<String> getRoleTypes() {
        return Collections.unmodifiableSet(this.roleTypes);
    }

    public void setRoleTypes(Set<String> roleTypes) {
        this.roleTypes.clear();
        this.roleTypes.addAll(roleTypes);
    }

    public boolean contains(EcsPermission permission) {
        return this.roleTypes.contains(permission.name());
    }

    public boolean addRoleType(String roleType) {
        return this.roleTypes.add(roleType);
    }

    public boolean removeRoleType(String roleType) {
        return this.roleTypes.remove(roleType);
    }

    public boolean canManageVendor() {
        String permission = EcsPermission.MANAGE.name();
        return this.roleTypes.contains(permission);
    }

    public boolean canManageAnyVendor() {
        String permission = EcsPermission.MANAGE_ANY.name();
        return this.roleTypes.contains(permission);
    }

    public boolean canPlaceTestOrder() {
        String permission = EcsPermission.TEST_PURCHASE.name();
        return this.roleTypes.contains(permission);
    }

    @JsonIgnore
    public boolean isAdmin() {
        return this.contains(EcsPermission.ADMIN);
    }

    @JsonIgnore
    public boolean isNotAdmin() {
        return !this.contains(EcsPermission.ADMIN);
    }

    @JsonIgnore
    public boolean isTestPurchaser() {
        return this.contains(EcsPermission.TEST_PURCHASE);
    }

    @JsonIgnore
    public boolean isManager() {
        return this.contains(EcsPermission.MANAGE) || this.contains(EcsPermission.MANAGE_ANY);
    }

    @JsonIgnore
    public boolean isNotManager() {
        return !this.isManager();
    }

    @JsonIgnore
    public boolean isManagerOfAny() {
        return this.contains(EcsPermission.MANAGE_ANY);
    }

    @JsonIgnore
    public boolean isBetaUser() {
        return this.contains(EcsPermission.BETA_FEATURES);
    }
}

