/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.accounts;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.lib.couchace.DefaultCouchStore;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.config.CouchServersConfig;
import org.tiogasolutions.push.kernel.system.PushCouchServer;

@Component
public class DomainStore
extends DefaultCouchStore<DomainProfileEntity> {
    public static final String DOMAIN_DESIGN_NAME = "domainProfile";
    private final String databaseName;

    @Autowired
    public DomainStore(PushCouchServer couchServer, CouchServersConfig config) {
        super((CouchServer)couchServer, DomainProfileEntity.class);
        this.databaseName = config.getMasterDatabaseName();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDesignName() {
        return DOMAIN_DESIGN_NAME;
    }

    public List<DomainProfileEntity> getDomains(Account account) {
        if (account == null) {
            return null;
        }
        return super.getEntities("byAccountId", new String[]{account.getAccountId()});
    }

    public DomainProfileEntity getByDomainKey(String domainKey) {
        if (domainKey == null) {
            return null;
        }
        List response = super.getEntities("byDomainKey", new String[]{domainKey});
        return response.isEmpty() ? null : (DomainProfileEntity)response.get(0);
    }

    public List<DomainProfileEntity> getAll() {
        return super.getEntities("byDomainKey");
    }

    public void createDatabase(CouchDatabase database) {
        PushCouchServer.createMainDatabase(database);
    }
}

