/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel.accounts;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.DateUtils;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.kernel.accounts.actions.ChangePasswordAction;
import org.tiogasolutions.push.kernel.accounts.actions.ConfirmEmailAction;
import org.tiogasolutions.push.kernel.accounts.actions.CreateAccountAction;
import org.tiogasolutions.push.kernel.accounts.actions.UpdateAccountAction;
import org.tiogasolutions.push.kernel.actions.CreateDomainAction;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.pub.internal.CpIdGenerator;
import org.tiogasolutions.push.pub.internal.RequestErrors;

@CouchEntity(value="account")
public class Account {
    public static final String INVALID_USER_NAME_OR_PASSWORD = "Invalid user name or password";
    private String accountId;
    private String revision;
    private LocalDateTime createdAt;
    private String password;
    private String tempPassword;
    private String firstName;
    private String lastName;
    private String emailAddress;
    private boolean emailConfirmed;
    private String emailConfirmationCode;

    @JsonCreator
    private Account(@JacksonInject(value="accountId") String accountId, @JacksonInject(value="revision") String revision, @JsonProperty(value="createdAt") LocalDateTime createdAt, @JsonProperty(value="password") String password, @JsonProperty(value="tempPassword") String tempPassword, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="emailConfirmed") boolean emailConfirmed, @JsonProperty(value="emailConfirmationCode") String emailConfirmationCode) {
        this.accountId = accountId;
        this.revision = revision;
        this.createdAt = createdAt;
        this.password = password;
        this.tempPassword = tempPassword;
        this.firstName = firstName;
        this.lastName = lastName;
        this.emailAddress = emailAddress;
        this.emailConfirmed = emailConfirmed;
        this.emailConfirmationCode = emailConfirmationCode;
    }

    public Account(CreateAccountAction action) {
        this.accountId = CpIdGenerator.newId();
        this.createdAt = DateUtils.currentLocalDateTime();
        this.validatePasswords(action.getPassword(), action.getPasswordConfirmed());
        this.password = action.getPassword();
        this.firstName = action.getFirstName();
        this.lastName = action.getLastName();
        this.emailAddress = action.getEmailAddress();
        this.emailConfirmed = false;
        this.emailConfirmationCode = String.valueOf(System.currentTimeMillis());
        this.emailConfirmationCode = this.emailConfirmationCode.substring(this.emailConfirmationCode.length() - 5);
    }

    @CouchId
    public String getAccountId() {
        return this.accountId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public DomainProfileEntity add(CreateDomainAction action) {
        action.validate(new RequestErrors()).assertNoErrors();
        return new DomainProfileEntity(action);
    }

    public void apply(UpdateAccountAction action) {
        this.firstName = action.getFirstName();
        this.lastName = action.getLastName();
        this.emailAddress = action.getEmailAddress();
    }

    public void apply(ChangePasswordAction action) {
        this.validatePassword(action.getCurrent());
        this.validatePasswords(action.getPassword(), action.getConfirmed());
        this.password = action.getPassword();
    }

    public boolean hasTempPassword() {
        return StringUtils.isNotBlank((Object)this.tempPassword);
    }

    public String createTempPassword() {
        String tempPassword = String.valueOf(System.currentTimeMillis());
        this.tempPassword = tempPassword.substring(tempPassword.length() - 8);
        return this.tempPassword;
    }

    public void clearTempPassword() {
        this.tempPassword = null;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTempPassword() {
        return this.tempPassword;
    }

    public void validatePassword(String password) {
        if (EqualsUtils.objectsNotEqual((Object)this.password, (Object)password)) {
            throw ApiException.badRequest((String)INVALID_USER_NAME_OR_PASSWORD, (String[])new String[0]);
        }
    }

    public void validatePasswords(String password, String confirmed) {
        if (StringUtils.isBlank((Object)password) || !password.equals(confirmed)) {
            throw ApiException.badRequest((String)"The two passwords do not match.", (String[])new String[0]);
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getEmailConfirmationCode() {
        return this.emailConfirmationCode;
    }

    public void setEmailConfirmationCode(String emailConfirmationCode) {
        this.emailConfirmationCode = emailConfirmationCode;
    }

    public boolean isEmailConfirmed() {
        return this.emailConfirmed;
    }

    public void setEmailConfirmed(boolean emailConfirmed) {
        this.emailConfirmed = emailConfirmed;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object object) {
        if (object instanceof Account) {
            Account that = (Account)object;
            return this.accountId.equals(that.accountId);
        }
        return false;
    }

    public void confirmEmail(ConfirmEmailAction action) {
        if (EqualsUtils.objectsNotEqual((Object)action.getConfirmationCode(), (Object)this.emailConfirmationCode)) {
            throw ApiException.badRequest((String)"Invalid confirmation code.", (String[])new String[0]);
        }
        this.emailConfirmed = true;
        this.emailConfirmationCode = null;
    }

    public String toString() {
        return this.emailAddress;
    }
}

