/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.kernel;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.jackson.PushObjectMapper;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.pub.common.RequestStatus;

public abstract class AbstractDelegate
implements Runnable {
    protected final ExecutionContext executionContext;
    protected final PushObjectMapper objectMapper;
    protected final PushRequest pushRequest;
    protected final PushRequestStore pushRequestStore;

    protected abstract RequestStatus processRequest() throws Exception;

    protected AbstractDelegate(ExecutionContext executionContext, PushObjectMapper objectMapper, PushRequestStore pushRequestStore, PushRequest pushRequest) {
        this.pushRequest = pushRequest;
        this.objectMapper = objectMapper;
        this.pushRequestStore = pushRequestStore;
        this.executionContext = executionContext;
    }

    @Override
    public final void run() {
        this.execute(false);
    }

    public void retry() {
        this.execute(true);
    }

    public boolean execute(boolean retry) {
        boolean success = true;
        if (retry) {
            this.pushRequest.addNote("** WARNING ** the API Request is being reprocessed.");
        }
        try {
            this.processRequest();
        }
        catch (Exception ex) {
            success = this.failed(ex, false);
        }
        try {
            if (success) {
                this.processCallback();
            }
        }
        catch (Exception ex) {
            success = this.failed(ex, true);
        }
        this.pushRequestStore.update(this.pushRequest);
        return success;
    }

    private boolean failed(Exception ex, boolean warning) {
        this.executionContext.setLastMessage("Execution failed: " + ExceptionUtils.getMessage((Throwable)ex));
        ex.printStackTrace();
        if (warning) {
            this.pushRequest.warn(ex);
        } else {
            this.pushRequest.failed(ex);
        }
        return false;
    }

    private void processCallback() throws Exception {
        String callbackURL = this.pushRequest.getPush().getCallbackUrl();
        if (callbackURL == null) {
            this.pushRequest.addNote("Callback not processed - url not specified");
            return;
        }
        String userName = AbstractDelegate.getUserName(callbackURL);
        String password = AbstractDelegate.getPassword(callbackURL);
        callbackURL = AbstractDelegate.stripAuthentication(callbackURL);
        Client client = ClientBuilder.newBuilder().build();
        JerseyUriBuilder uriBuilder = new JerseyUriBuilder().uri(callbackURL);
        this.pushRequest.addNote("Executing callback to " + callbackURL);
        String json = this.objectMapper.writeValueAsString((Object)this.pushRequest);
        Invocation.Builder builder = userName != null ? ((WebTarget)client.target((UriBuilder)uriBuilder).register((Object)HttpAuthenticationFeature.basic((String)userName, (String)password))).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}) : client.target((UriBuilder)uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Response jerseyResponse = builder.post(Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        int status = jerseyResponse.getStatus();
        if (status / 100 == 2) {
            this.pushRequest.addNote("Callback completed: HTTP " + status);
        } else {
            this.pushRequest.warn("Callback failed: HTTP " + status);
        }
    }

    public static String getUserName(String callbackURL) {
        if (StringUtils.isBlank((Object)callbackURL)) {
            return null;
        }
        int posA = callbackURL.indexOf("://");
        if (posA < 0) {
            return null;
        }
        int posB = callbackURL.indexOf("@", posA);
        if (posB < 0) {
            return null;
        }
        String auth = callbackURL.substring(posA + 3, posB);
        int pos = auth.indexOf(":");
        return pos < 0 ? auth : auth.substring(0, pos);
    }

    public static String getPassword(String callbackURL) {
        if (StringUtils.isBlank((Object)callbackURL)) {
            return null;
        }
        int posA = callbackURL.indexOf("://");
        if (posA < 0) {
            return null;
        }
        int posB = callbackURL.indexOf("@", posA);
        if (posB < 0) {
            return null;
        }
        String auth = callbackURL.substring(posA + 3, posB);
        int pos = auth.indexOf(":");
        return pos < 0 ? null : auth.substring(pos + 1);
    }

    public static String stripAuthentication(String callbackURL) {
        if (StringUtils.isBlank((Object)callbackURL)) {
            return callbackURL;
        }
        int posA = callbackURL.indexOf("://");
        if (posA < 0) {
            return callbackURL;
        }
        int posB = callbackURL.indexOf("@", posA);
        if (posB < 0) {
            return callbackURL;
        }
        String left = callbackURL.substring(0, posA + 3);
        String right = callbackURL.substring(posB + 1);
        return left + right;
    }

    public void start() {
        new Thread(this).start();
    }
}

