/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.springframework.stereotype.Component;
import org.tiogasolutions.push.engine.jaxrs.security.ApiAuthenticationFilter;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthenticationFilter;
import org.tiogasolutions.push.engine.jaxrs.security.PushRequestFilter;
import org.tiogasolutions.push.engine.resources.RootResource;
import org.tiogasolutions.push.engine.view.LocalResourceMessageBodyWriter;
import org.tiogasolutions.push.engine.view.ThymeleafMessageBodyWriter;
import org.tiogasolutions.push.pub.XmppPush;
import org.tiogasolutions.push.pub.common.PingPush;
import org.tiogasolutions.push.pub.common.PushType;

@Component
public class PushApplication
extends Application {
    private final Set<Class<?>> classes = new HashSet();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public PushApplication() {
        this.classes.add(PushRequestFilter.class);
        this.classes.add(ApiAuthenticationFilter.class);
        this.classes.add(MngtAuthenticationFilter.class);
        this.classes.add(ThymeleafMessageBodyWriter.class);
        this.classes.add(LocalResourceMessageBodyWriter.class);
        this.classes.add(RootResource.class);
        PingPush.PUSH_TYPE.getCode();
        new PushType(XmppPush.class, "im", "IM");
        this.checkForDuplicates();
    }

    private void checkForDuplicates() {
        HashSet existing = new HashSet();
        for (Class<?> type : this.classes) {
            if (type == null || !existing.contains(type)) continue;
            String msg = String.format("The class %s has already been registered.", type.getName());
            throw new IllegalArgumentException(msg);
        }
        existing.clear();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }
}

