/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.system;

import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.couchace.core.api.response.EntityDocument;
import org.tiogasolutions.dev.common.DateUtils;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.kernel.requests.QueryResult;

public class CpJobs {
    public static final Log log = LogFactory.getLog(CpJobs.class);
    private static final AtomicBoolean runningCompact = new AtomicBoolean(false);
    private static final AtomicBoolean runningPruner = new AtomicBoolean(false);
    private final DomainStore domainStore;
    private final PushRequestStore pushRequestStore;

    @Autowired
    public CpJobs(DomainStore domainStore, PushRequestStore pushRequestStore) {
        this.domainStore = domainStore;
        this.pushRequestStore = pushRequestStore;
    }

    public void cleanAndCompactDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneEvents() {
        try {
            if (runningPruner.compareAndSet(false, true)) {
                LocalDateTime now = DateUtils.currentLocalDateTime();
                List domains = this.domainStore.getAll();
                for (DomainProfileEntity domain : domains) {
                    this.pruneEvents(now, domain);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            runningPruner.set(false);
        }
    }

    private void pruneEvents(LocalDateTime now, DomainProfileEntity domain) {
        if (domain.getRetentionDays() <= 0) {
            return;
        }
        int count = 0;
        QueryResult queryResult = this.pushRequestStore.getByClient(domain, 100);
        do {
            List list = queryResult.getDocumentList();
            for (EntityDocument document : list) {
                this.pruneEvents(now, domain, (EntityDocument<PushRequest>)document);
            }
            log.info((Object)String.format("Deleted %s records\n", count += queryResult.getSize()));
        } while (queryResult.nextPage());
    }

    private void pruneEvents(LocalDateTime now, DomainProfileEntity domain, EntityDocument<PushRequest> document) {
        int days = domain.getRetentionDays();
        PushRequest pushRequest = (PushRequest)document.getEntity();
        LocalDateTime later = pushRequest.getCreatedAt().plusWeeks(days);
        if (now.isAfter(later)) {
            this.pushRequestStore.deleteByDocumentId(document.getDocumentId(), document.getDocumentRevision());
        }
    }
}

