/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.manage.client.emails;

import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthentication;
import org.tiogasolutions.push.engine.resources.manage.client.emails.EmailModel;
import org.tiogasolutions.push.engine.resources.manage.client.emails.EmailsModel;
import org.tiogasolutions.push.engine.view.Thymeleaf;
import org.tiogasolutions.push.engine.view.ThymeleafViewFactory;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.Plugin;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.pub.SesEmailPush;
import org.tiogasolutions.push.pub.SmtpEmailPush;
import org.tiogasolutions.push.pub.common.CommonEmail;
import org.tiogasolutions.push.pub.common.Push;

@MngtAuthentication
public class ManageEmailsResource {
    private final Account account;
    private final DomainProfileEntity domainProfile;
    private final PluginManager pluginManager;
    private final ExecutionManager executionManager;
    private final PushRequestStore pushRequestStore;

    public ManageEmailsResource(ExecutionManager executionManager, PushRequestStore pushRequestStore, PluginManager pluginManager, Account account, DomainProfileEntity domainProfile) {
        this.pluginManager = pluginManager;
        this.executionManager = executionManager;
        this.account = account;
        this.domainProfile = domainProfile;
        this.pushRequestStore = pushRequestStore;
    }

    @GET
    @Produces(value={"text/html"})
    public Thymeleaf viewEmailEvents() throws Exception {
        ArrayList<PushRequest> requests = new ArrayList<PushRequest>();
        requests.addAll(this.pushRequestStore.getByClientAndType(this.domainProfile, SesEmailPush.PUSH_TYPE));
        requests.addAll(this.pushRequestStore.getByClientAndType(this.domainProfile, SmtpEmailPush.PUSH_TYPE));
        EmailsModel model = new EmailsModel(this.account, this.domainProfile, requests);
        return new Thymeleaf(this.executionManager.getContext().getSession(), ThymeleafViewFactory.MANAGE_API_EMAILS, model);
    }

    @GET
    @Path(value="/{pushRequestId}")
    @Produces(value={"text/html"})
    public Thymeleaf viewEmailEvent(@PathParam(value="pushRequestId") String pushRequestId) throws Exception {
        PushRequest pushRequest = this.pushRequestStore.getByPushRequestId(pushRequestId);
        CommonEmail email = pushRequest.getCommonEmail();
        EmailModel model = new EmailModel(this.account, this.domainProfile, pushRequest, email);
        return new Thymeleaf(this.executionManager.getContext().getSession(), ThymeleafViewFactory.MANAGE_API_EMAIL, model);
    }

    @POST
    @Path(value="/{pushRequestId}/retry")
    public Response retryEmailMessage(@Context UriInfo uriInfo, @PathParam(value="pushRequestId") String pushRequestId) throws Exception {
        Plugin plugin;
        PushRequest pushRequest = this.pushRequestStore.getByPushRequestId(pushRequestId);
        CommonEmail push = (CommonEmail)pushRequest.getPush();
        if (SesEmailPush.PUSH_TYPE.equals((Object)push.getPushType())) {
            plugin = this.pluginManager.getPlugin(push.getPushType());
            plugin.newDelegate(this.domainProfile, pushRequest, (Push)((SesEmailPush)push)).retry();
        } else if (SmtpEmailPush.PUSH_TYPE.equals((Object)push.getPushType())) {
            plugin = this.pluginManager.getPlugin(push.getPushType());
            plugin.newDelegate(this.domainProfile, pushRequest, (Push)((SmtpEmailPush)push)).retry();
        } else {
            String msg = String.format("The retry operation is not supported for the push type \"%s\".", push.getPushType().getCode());
            throw new UnsupportedOperationException(msg);
        }
        URI uri = uriInfo.getBaseUriBuilder().path("manage").path("domain").path(this.domainProfile.getDomainKey()).path(pushRequest.getPushRequestId()).build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }
}

