/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.manage.client;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthentication;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.Plugin;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.pub.common.PushType;

@MngtAuthentication
public class ManagePluginApi {
    private final PushType pushType;
    private final PluginManager pluginManager;
    private final DomainProfileEntity domainProfile;
    private final ExecutionManager executionManager;

    public ManagePluginApi(ExecutionManager executionManager, PluginManager pluginManager, DomainProfileEntity domainProfile, PushType pushType) {
        this.pluginManager = pluginManager;
        this.executionManager = executionManager;
        this.pushType = (PushType)ExceptionUtils.assertNotNull((Object)pushType, (String)"pushType");
        this.domainProfile = (DomainProfileEntity)ExceptionUtils.assertNotNull((Object)domainProfile, (String)"domainProfile");
    }

    public Response redirect() throws Exception {
        String path = String.format("manage/domain/%s", this.domainProfile.getDomainKey());
        return Response.seeOther((URI)new URI(path)).build();
    }

    @POST
    public Response updateConfig(Map<String, String> params) throws Exception {
        Plugin plugin = this.pluginManager.getPlugin(this.pushType);
        plugin.updateConfig(this.domainProfile, params);
        return this.redirect();
    }

    @POST
    @Path(value="/delete")
    public Response deleteConfig() throws Exception {
        Plugin plugin = this.pluginManager.getPlugin(this.pushType);
        plugin.deleteConfig(this.domainProfile);
        return this.redirect();
    }

    @POST
    @Path(value="/test")
    public Response testConfig() throws Exception {
        Plugin plugin = this.pluginManager.getPlugin(this.pushType);
        plugin.test(this.domainProfile);
        return this.redirect();
    }
}

