/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.manage.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthentication;
import org.tiogasolutions.push.engine.resources.manage.client.DomainRequestsModel;
import org.tiogasolutions.push.engine.resources.manage.client.ManageDomainModel;
import org.tiogasolutions.push.engine.resources.manage.client.ManagePluginApi;
import org.tiogasolutions.push.engine.resources.manage.client.emails.ManageEmailsResource;
import org.tiogasolutions.push.engine.view.Thymeleaf;
import org.tiogasolutions.push.engine.view.ThymeleafViewFactory;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.actions.UpdateDomainAction;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.Plugin;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.kernel.requests.QueryResult;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.pub.common.PushType;

@MngtAuthentication
public class ManageDomainResource {
    private final DomainProfileEntity domainProfile;
    private final PluginManager pluginManager;
    private final ExecutionManager executionManager;
    private final DomainStore domainStore;
    private final AccountStore accountStore;
    private final PushRequestStore pushRequestStore;

    public ManageDomainResource(ExecutionManager executionManager, DomainStore domainStore, AccountStore accountStore, PushRequestStore pushRequestStore, PluginManager pluginManager, String domainKey) {
        this.pluginManager = pluginManager;
        this.executionManager = executionManager;
        this.domainStore = domainStore;
        this.accountStore = accountStore;
        this.pushRequestStore = pushRequestStore;
        this.domainProfile = domainStore.getByDomainKey(domainKey);
        if (this.domainProfile == null) {
            throw ApiException.notFound((String)domainKey, (String[])new String[0]);
        }
        this.executionManager.getContext().setDomain(this.domainProfile);
    }

    private Account getAccount() {
        return this.executionManager.getContext().getAccount();
    }

    @GET
    @Produces(value={"text/html"})
    public Thymeleaf viewDomain() throws Exception {
        String lastMessage = this.executionManager.getContext().getSession().getLastMessage();
        this.executionManager.getContext().setLastMessage(null);
        this.accountStore.update((Object)this.getAccount());
        ManageDomainModel model = new ManageDomainModel(this.executionManager, this.domainProfile, this.pluginManager, lastMessage);
        return new Thymeleaf(this.executionManager.getContext().getSession(), ThymeleafViewFactory.MANAGE_API_CLIENT, model);
    }

    @GET
    @Path(value="/icon/{pushType}")
    @Produces(value={"image/png"})
    public Response getEnabledIcon(@PathParam(value="pushType") PushType pushType) throws Exception {
        Plugin plugin = this.pluginManager.getPlugin(pushType);
        byte[] bytes = plugin.getIcon(this.domainProfile);
        return Response.ok((Object)bytes, (String)"image/png").build();
    }

    @GET
    @Path(value="/requests")
    @Produces(value={"text/html"})
    public Thymeleaf viewEvents() throws Exception {
        QueryResult queryResult = this.pushRequestStore.getByClient(this.domainProfile, 500);
        ArrayList<PushRequest> requests = new ArrayList<PushRequest>(queryResult.getEntityList());
        Collections.sort(requests);
        Collections.reverse(requests);
        DomainRequestsModel model = new DomainRequestsModel(this.getAccount(), this.domainProfile, requests);
        return new Thymeleaf(this.executionManager.getContext().getSession(), ThymeleafViewFactory.MANAGE_API_REQUESTS, model);
    }

    @POST
    @Path(value="/requests/delete-all")
    public Response deleteEvents() throws Exception {
        QueryResult queryResult = this.pushRequestStore.getByClient(this.domainProfile, 500);
        ArrayList requests = new ArrayList(queryResult.getEntityList());
        for (PushRequest request : requests) {
            this.pushRequestStore.delete((Object)request);
        }
        this.executionManager.getContext().setLastMessage("All API Requests deleted");
        this.domainStore.update((Object)this.domainProfile);
        URI uri = this.executionManager.getContext().getUriInfo().getBaseUriBuilder().path("manage").path("domain").path(this.domainProfile.getDomainKey()).path("requests").build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @Path(value="/emails")
    public ManageEmailsResource getManageEmailsResource() throws Exception {
        return new ManageEmailsResource(this.executionManager, this.pushRequestStore, this.pluginManager, this.getAccount(), this.domainProfile);
    }

    @POST
    public Response updateClient(@FormParam(value="domainKey") String domainKey, @FormParam(value="domainPassword") String domainPassword, @FormParam(value="retentionDays") int retentionDays) throws Exception {
        if (!this.domainProfile.getDomainKey().equals(domainKey) && this.domainStore.getByDomainKey(domainKey) != null) {
            String msg = String.format("The client name %s already exists.", domainKey);
            throw ApiException.badRequest((String)msg, (String[])new String[0]);
        }
        UpdateDomainAction action = new UpdateDomainAction(domainKey, domainPassword, retentionDays);
        this.executionManager.getContext().setLastMessage("Domain configuration changed.");
        this.domainProfile.apply(action);
        this.domainStore.update((Object)this.domainProfile);
        URI uri = this.executionManager.getContext().getUriInfo().getBaseUriBuilder().path("manage").path("domain").path(this.domainProfile.getDomainKey()).build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }

    @POST
    @Path(value="/delete")
    public Response deleteClient() throws Exception {
        this.domainStore.delete((Object)this.domainProfile);
        return Response.seeOther((URI)new URI("manage/account")).build();
    }

    @Path(value="/{pushType}")
    public ManagePluginApi getManagePluginApi(@PathParam(value="pushType") PushType pushType) throws Exception {
        return new ManagePluginApi(this.executionManager, this.pluginManager, this.domainProfile, pushType);
    }
}

