/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.manage.account;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthentication;
import org.tiogasolutions.push.engine.resources.manage.account.ManageAccountModel;
import org.tiogasolutions.push.engine.view.Thymeleaf;
import org.tiogasolutions.push.engine.view.ThymeleafViewFactory;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.accounts.actions.ChangePasswordAction;
import org.tiogasolutions.push.kernel.accounts.actions.UpdateAccountAction;
import org.tiogasolutions.push.kernel.execution.ExecutionContext;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.kernel.system.SessionStore;

@MngtAuthentication
public class ManageAccountResource {
    private final SessionStore sessionStore;
    private final PluginManager pluginManager;
    private final ExecutionManager executionManager;
    private final DomainStore domainStore;
    private final AccountStore accountStore;

    public ManageAccountResource(ExecutionManager executionManager, DomainStore domainStore, AccountStore accountStore, PluginManager pluginManager, SessionStore sessionStore) {
        this.sessionStore = sessionStore;
        this.pluginManager = pluginManager;
        this.executionManager = executionManager;
        this.domainStore = domainStore;
        this.accountStore = accountStore;
    }

    @GET
    public Thymeleaf viewAccount() throws IOException {
        ExecutionContext execContext = this.executionManager.getContext();
        Account account = execContext.getAccount();
        List domains = this.domainStore.getDomains(account);
        ManageAccountModel model = new ManageAccountModel(this.executionManager, this.pluginManager, account, domains);
        return new Thymeleaf(execContext.getSession(), ThymeleafViewFactory.MANAGE_ACCOUNT, model);
    }

    @POST
    @Path(value="update")
    public Response updateAccount(@FormParam(value="firstName") String firstName, @FormParam(value="lastName") String lastName, @FormParam(value="emailAddress") String newEmailAddress) throws Exception {
        Account account = this.executionManager.getContext().getAccount();
        String oldEmailAddress = account.getEmailAddress();
        if (EqualsUtils.objectsNotEqual((Object)oldEmailAddress, (Object)newEmailAddress) && this.accountStore.getByEmail(newEmailAddress) != null) {
            String msg = String.format("The email address %s is already in use.", newEmailAddress);
            throw ApiException.conflict((String)msg, (String[])new String[0]);
        }
        UpdateAccountAction action = new UpdateAccountAction(firstName, lastName, newEmailAddress);
        account.apply(action);
        this.accountStore.update((Object)account);
        if (EqualsUtils.objectsNotEqual((Object)oldEmailAddress, (Object)newEmailAddress)) {
            this.sessionStore.newSession(newEmailAddress);
        }
        this.executionManager.getContext().setLastMessage("You account details have been updated.");
        return Response.seeOther((URI)new URI("manage/account")).build();
    }

    @POST
    @Path(value="password")
    public Response changePassword(@FormParam(value="oldPassword") String oldPassword, @FormParam(value="newPassword") String newPassword, @FormParam(value="confirmed") String confirmed) throws Exception {
        Account account = this.executionManager.getContext().getAccount();
        ChangePasswordAction action = new ChangePasswordAction(oldPassword, newPassword, confirmed);
        account.apply(action);
        this.accountStore.update((Object)account);
        this.executionManager.getContext().setLastMessage("You password has been updated.");
        return Response.seeOther((URI)new URI("manage/account")).build();
    }
}

