/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.manage;

import java.net.URI;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthentication;
import org.tiogasolutions.push.engine.resources.manage.account.ManageAccountResource;
import org.tiogasolutions.push.engine.resources.manage.client.ManageDomainResource;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.actions.CreateDomainAction;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.Plugin;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.kernel.system.SessionStore;
import org.tiogasolutions.push.pub.common.PushType;

@MngtAuthentication
public class ManageResource {
    private final UriInfo uriInfo;
    private final SessionStore sessionStore;
    private final PluginManager pluginManager;
    private final ExecutionManager executionManager;
    private final DomainStore domainStore;
    private final AccountStore accountStore;
    private final PushRequestStore pushRequestStore;

    public ManageResource(ExecutionManager executionManager, DomainStore domainStore, AccountStore accountStore, PushRequestStore pushRequestStore, SessionStore sessionStore, PluginManager pluginManager, UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        this.sessionStore = sessionStore;
        this.pluginManager = pluginManager;
        this.executionManager = executionManager;
        this.domainStore = domainStore;
        this.accountStore = accountStore;
        this.pushRequestStore = pushRequestStore;
    }

    @GET
    public Response redirect() throws Exception {
        return Response.seeOther((URI)new URI("manage/account")).build();
    }

    @GET
    @Produces(value={"image/png"})
    @Path(value="/{pushType}/icon-enabled")
    public Response getEnabledIcon(@PathParam(value="pushType") PushType pushType) throws Exception {
        Plugin plugin = this.pluginManager.getPlugin(pushType);
        byte[] bytes = plugin.getEnabledIcon();
        return Response.ok((Object)bytes, (String)"image/png").build();
    }

    @GET
    @Produces(value={"image/png"})
    @Path(value="/{pushType}/icon-disabled")
    public Response getDisabledIcon(@PathParam(value="pushType") PushType pushType) throws Exception {
        Plugin plugin = this.pluginManager.getPlugin(pushType);
        byte[] bytes = plugin.getDisabledIcon();
        return Response.ok((Object)bytes, (String)"image/png").build();
    }

    @Path(value="/account")
    public ManageAccountResource getManageAccountResource() {
        return new ManageAccountResource(this.executionManager, this.domainStore, this.accountStore, this.pluginManager, this.sessionStore);
    }

    @Path(value="/domain/{domainKey}")
    public ManageDomainResource getManageDomainResource(@PathParam(value="domainKey") String domainKey) throws Exception {
        return new ManageDomainResource(this.executionManager, this.domainStore, this.accountStore, this.pushRequestStore, this.pluginManager, domainKey);
    }

    @POST
    @Path(value="/domain")
    public Response createDomain(@FormParam(value="domainKey") String domainKey, @FormParam(value="domainPassword") String domainPassword) throws Exception {
        if (this.domainStore.getByDomainKey(domainKey = ((String)ExceptionUtils.assertNotNull((Object)domainKey, (String)"domainKey")).toLowerCase()) != null) {
            throw ApiException.badRequest((String)String.format("The domain \"%s\" already exists.", domainKey), (String[])new String[0]);
        }
        CreateDomainAction action = new CreateDomainAction(this.executionManager.getContext().getAccount(), domainKey, domainPassword);
        DomainProfileEntity domain = this.executionManager.getContext().getAccount().add(action);
        this.domainStore.create((Object)domain);
        this.accountStore.update((Object)this.executionManager.getContext().getAccount());
        this.executionManager.newContext(this.uriInfo).setDomain(domain);
        this.pushRequestStore.getDatabase();
        URI uri = this.uriInfo.getBaseUriBuilder().path("manage").path("domain").path(domainKey).build(new Object[0]);
        return Response.seeOther((URI)uri).build();
    }
}

