/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.api;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tiogasolutions.dev.common.net.HttpStatusCode;
import org.tiogasolutions.pub.PubItem;
import org.tiogasolutions.push.engine.jaxrs.security.ApiAuthentication;
import org.tiogasolutions.push.engine.system.PubUtils;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.Plugin;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.pub.common.PushType;
import org.tiogasolutions.push.pub.domain.PubConfig;

@ApiAuthentication
public class ConfigResource {
    public static final Log log = LogFactory.getLog(ConfigResource.class);
    private final ExecutionManager executionManager;
    private final PubUtils pubUtils;

    public ConfigResource(ExecutionManager executionManager, PubUtils pubUtils) {
        this.pubUtils = pubUtils;
        this.executionManager = executionManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getConfig() throws Exception {
        DomainProfileEntity domainProfile = this.executionManager.getContext().getDomain();
        PluginManager pluginManager = this.executionManager.getPluginManager();
        PubConfig config = this.pubUtils.toConfig(HttpStatusCode.OK, domainProfile, pluginManager);
        return this.pubUtils.toResponse((PubItem)config).build();
    }

    @PUT
    @Path(value="{pushType}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response putConfig(@PathParam(value="pushType") PushType pushType, Map<String, String> params) throws Exception {
        log.info((Object)("Updating " + pushType));
        PluginManager pluginManager = this.executionManager.getPluginManager();
        DomainProfileEntity domainProfile = this.executionManager.getContext().getDomain();
        Plugin plugin = pluginManager.getPlugin(pushType);
        plugin.updateConfig(domainProfile, params);
        PubConfig config = this.pubUtils.toConfig(HttpStatusCode.OK, domainProfile, pluginManager);
        return this.pubUtils.toResponse((PubItem)config).build();
    }

    @DELETE
    @Path(value="{pushType}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteConfig(@PathParam(value="pushType") PushType pushType) throws Exception {
        PluginManager pluginManager = this.executionManager.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pushType);
        DomainProfileEntity domainProfile = this.executionManager.getContext().getDomain();
        plugin.deleteConfig(domainProfile);
        PubConfig config = this.pubUtils.toConfig(HttpStatusCode.OK, domainProfile, pluginManager);
        return this.pubUtils.toResponse((PubItem)config).build();
    }

    @POST
    @Path(value="{pushType}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response testConfig(@PathParam(value="pushType") PushType pushType) throws Exception {
        PluginManager pluginManager = this.executionManager.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pushType);
        DomainProfileEntity domainProfile = this.executionManager.getContext().getDomain();
        plugin.test(domainProfile);
        PubConfig config = this.pubUtils.toConfig(HttpStatusCode.OK, domainProfile, pluginManager);
        return this.pubUtils.toResponse((PubItem)config).build();
    }
}

