/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.tiogasolutions.push.engine.jaxrs.security.ApiAuthentication;
import org.tiogasolutions.push.engine.resources.api.ConfigResource;
import org.tiogasolutions.push.engine.resources.api.DomainsResourceV3;
import org.tiogasolutions.push.engine.system.PubUtils;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.plugins.PushProcessor;
import org.tiogasolutions.push.pub.common.Push;
import org.tiogasolutions.push.pub.common.PushResponse;

@ApiAuthentication
public class ApiResource {
    private final PubUtils pubUtils;
    private final ExecutionManager executionManager;

    public ApiResource(ExecutionManager executionManager, PubUtils pubUtils) throws Exception {
        this.pubUtils = pubUtils;
        this.executionManager = executionManager;
    }

    @Path(value="domains")
    public DomainsResourceV3 getDomainResourceV3() {
        return new DomainsResourceV3(this.executionManager, this.pubUtils);
    }

    @POST
    @Path(value="callback")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response callback(String msg) throws Exception {
        return Response.ok().build();
    }

    @POST
    @Path(value="pushes")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response postPush(Push push) throws Exception {
        DomainProfileEntity domain = this.executionManager.getContext().getDomain();
        PushProcessor pushProcessor = this.executionManager.getPushProcessor();
        PushResponse response = pushProcessor.execute(3, domain, push);
        return Response.ok((Object)response, (String)"application/json").build();
    }

    @Path(value="config")
    public ConfigResource getConfigResource() {
        return new ConfigResource(this.executionManager, this.pubUtils);
    }
}

