/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.resources;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.engine.resources.RootResourceSupport;
import org.tiogasolutions.push.engine.resources.api.ApiResource;
import org.tiogasolutions.push.engine.resources.manage.ManageResource;
import org.tiogasolutions.push.engine.system.PubUtils;
import org.tiogasolutions.push.engine.view.Thymeleaf;
import org.tiogasolutions.push.engine.view.ThymeleafViewFactory;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.requests.PushRequest;
import org.tiogasolutions.push.kernel.requests.PushRequestStore;
import org.tiogasolutions.push.kernel.system.PluginManager;
import org.tiogasolutions.push.kernel.system.Session;
import org.tiogasolutions.push.kernel.system.SessionStore;

@Path(value="/")
@Scope(value="prototype")
public class RootResource
extends RootResourceSupport {
    public static final int REASON_CODE_INVALID_USERNAME_OR_PASSWORD = -1;
    public static final int REASON_CODE_UNAUTHORIZED = -2;
    public static final int REASON_SIGNED_OUT = -3;
    private static final Log log = LogFactory.getLog(RootResource.class);
    @Context
    private UriInfo uriInfo;
    @Autowired
    private ExecutionManager executionManager;
    @Autowired
    private SessionStore sessionStore;
    @Autowired
    private PluginManager pluginManager;
    @Autowired
    private AccountStore accountStore;
    @Autowired
    private DomainStore domainStore;
    @Autowired
    private PushRequestStore pushRequestStore;

    public RootResource() {
        log.info((Object)"Created ");
    }

    public PubUtils newPubUtils() {
        return new PubUtils(this.uriInfo);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @GET
    @Produces(value={"text/html"})
    public Thymeleaf getWelcome(@QueryParam(value="r") int reasonCode, @QueryParam(value="username") String username, @QueryParam(value="password") String password) throws IOException {
        String message = "";
        if (-1 == reasonCode) {
            message = "Invalid username or password";
        } else if (-2 == reasonCode) {
            message = "Your session has expired";
        } else if (-3 == reasonCode) {
            message = "You have successfully signed out";
        }
        return new Thymeleaf(this.executionManager.getContext().getSession(), ThymeleafViewFactory.WELCOME, new WelcomeModel(this.executionManager.getContext().getAccount(), message, username, password));
    }

    @POST
    @Path(value="sign-in")
    @Produces(value={"text/html"})
    public Response signIn(@FormParam(value="username") String username, @FormParam(value="password") String password, @CookieParam(value="session-id") String sessionId) throws Exception {
        Account account = this.accountStore.getByEmail(username);
        if (account == null || EqualsUtils.objectsNotEqual((Object)account.getPassword(), (Object)password)) {
            this.sessionStore.remove(sessionId);
            NewCookie sessionCookie = SessionStore.toCookie((UriInfo)this.getUriInfo(), null);
            URI other = this.getUriInfo().getBaseUriBuilder().queryParam("r", new Object[]{-1}).build(new Object[0]);
            return Response.seeOther((URI)other).cookie(new NewCookie[]{sessionCookie}).build();
        }
        Session session = this.sessionStore.newSession(username);
        NewCookie sessionCookie = SessionStore.toCookie((UriInfo)this.getUriInfo(), (Session)session);
        URI other = this.getUriInfo().getBaseUriBuilder().path("manage").build(new Object[0]);
        return Response.seeOther((URI)other).cookie(new NewCookie[]{sessionCookie}).build();
    }

    @GET
    @Path(value="sign-out")
    @Produces(value={"text/html"})
    public Response signOut(@CookieParam(value="session-id") String sessionId) throws Exception {
        if (sessionId != null) {
            this.sessionStore.remove(sessionId);
        }
        NewCookie sessionCookie = SessionStore.toCookie((UriInfo)this.getUriInfo(), null);
        URI other = this.getUriInfo().getBaseUriBuilder().queryParam("r", new Object[]{-3}).build(new Object[0]);
        return Response.seeOther((URI)other).cookie(new NewCookie[]{sessionCookie}).build();
    }

    @Path(value="api/v3")
    public ApiResource getApiResourceV2() throws Exception {
        return new ApiResource(this.executionManager, this.newPubUtils());
    }

    @Path(value="manage")
    public ManageResource getManageResource() {
        return new ManageResource(this.executionManager, this.domainStore, this.accountStore, this.pushRequestStore, this.sessionStore, this.pluginManager, this.uriInfo);
    }

    @GET
    @Path(value="/q/{pushRequestId}")
    public Response resolveCallback(@PathParam(value="pushRequestId") String pushRequestId) throws URISyntaxException {
        PushRequest request = this.pushRequestStore.getByPushRequestId(pushRequestId);
        if (request == null) {
            throw ApiException.notFound((String)("API request not found for " + pushRequestId), (String[])new String[0]);
        }
        DomainProfileEntity domain = (DomainProfileEntity)this.domainStore.getByDocumentId(request.getDomainId());
        if (domain == null) {
            throw ApiException.notFound((String)("Domain not found for " + request.getDomainId()), (String[])new String[0]);
        }
        return Response.seeOther((URI)this.getUriInfo().getBaseUriBuilder().build(new Object[0])).build();
    }

    @GET
    @Path(value="health-check")
    @Produces(value={"text/html"})
    public Response healthCheck$GET() {
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public static class WelcomeModel {
        private final Account account;
        private final String message;
        private final String emailAddress;
        private final String password;

        public WelcomeModel(Account account, String message, String emailAddress, String password) {
            this.account = account;
            this.message = message;
            this.emailAddress = emailAddress;
            this.password = password;
        }

        public Account getAccount() {
            return this.account;
        }

        public String getMessage() {
            return this.message;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

