/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.jaxrs.security;

import java.io.IOException;
import java.util.Collections;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.system.Session;
import org.tiogasolutions.push.kernel.system.SessionStore;

@Provider
@PreMatching
@Priority(value=1000)
public class PushResponseFilter
implements ContainerResponseFilter {
    private final SessionStore sessionStore;
    private final ExecutionManager executionManager;

    @Autowired
    public PushResponseFilter(ExecutionManager executionManager, SessionStore sessionStore) {
        this.sessionStore = sessionStore;
        this.executionManager = executionManager;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"Accept, Content-Type, Authorization, Access-Control-Allow-Origin");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, DELETE, PUT, POST");
        responseContext.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        responseContext.getHeaders().add((Object)"X-UA-Compatible", (Object)"IE=Edge");
        responseContext.getHeaders().add((Object)"p3p", (Object)"CP=\"Push server does not have a P3P policy. Learn why here: https://www.TiogaSolutions.com/push/static/p3p.html\"");
        Session session = this.executionManager.getContext().getSession();
        boolean valid = this.sessionStore.isValid(session);
        if (session != null && valid) {
            session.renew();
            NewCookie cookie = SessionStore.toCookie((UriInfo)requestContext.getUriInfo(), (Session)session);
            responseContext.getHeaders().put((Object)"Set-Cookie", Collections.singletonList(cookie));
        }
        this.executionManager.removeExecutionContext();
    }
}

