/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.jaxrs.security;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.engine.jaxrs.security.MngtAuthentication;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;
import org.tiogasolutions.push.kernel.system.Session;
import org.tiogasolutions.push.kernel.system.SessionStore;

@Provider
@MngtAuthentication
@Priority(value=1001)
public class MngtAuthenticationFilter
implements ContainerRequestFilter {
    private final SessionStore sessionStore;
    private final AccountStore accountStore;
    private final ExecutionManager executionManager;

    @Autowired
    public MngtAuthenticationFilter(ExecutionManager executionManager, SessionStore sessionStore, AccountStore accountStore) {
        this.sessionStore = sessionStore;
        this.accountStore = accountStore;
        this.executionManager = executionManager;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            Session session = this.sessionStore.getSession(requestContext);
            if (session == null) {
                throw ApiException.unauthorized();
            }
            String emailAddress = session.getEmailAddress();
            Account account = this.accountStore.getByEmail(emailAddress);
            if (account == null) {
                throw ApiException.unauthorized();
            }
            SecurityContext securityContext = requestContext.getSecurityContext();
            requestContext.setSecurityContext((SecurityContext)new MngtSecurityContext(securityContext, account));
            this.executionManager.getContext().setAccount(account);
        }
        catch (ApiException e) {
            URI uri = requestContext.getUriInfo().getBaseUriBuilder().queryParam("r", new Object[]{-2}).build(new Object[0]);
            Response response = Response.seeOther((URI)uri).build();
            requestContext.abortWith(response);
        }
    }

    private static class MngtSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final Account account;

        public MngtSecurityContext(SecurityContext securityContext, Account account) {
            this.account = account;
            this.secure = securityContext.isSecure();
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "FORM_AUTH";
        }

        public Principal getUserPrincipal() {
            return () -> ((Account)this.account).getEmailAddress();
        }
    }
}

