/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.jaxrs.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.push.engine.jaxrs.security.ApiAuthentication;
import org.tiogasolutions.push.kernel.accounts.DomainStore;
import org.tiogasolutions.push.kernel.clients.DomainProfileEntity;
import org.tiogasolutions.push.kernel.execution.ExecutionManager;

@Provider
@ApiAuthentication
@Priority(value=1001)
public class ApiAuthenticationFilter
implements ContainerRequestFilter {
    private final DomainStore domainStore;
    private final ExecutionManager executionManager;

    @Autowired
    public ApiAuthenticationFilter(ExecutionManager executionManager, DomainStore domainStore) {
        this.domainStore = domainStore;
        this.executionManager = executionManager;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String password;
        String domainKey;
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (!authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            domainKey = basicAuth;
            password = null;
        } else {
            domainKey = basicAuth.substring(0, pos);
            password = basicAuth.substring(pos + 1);
        }
        DomainProfileEntity domainProfile = this.domainStore.getByDomainKey(domainKey);
        if (domainProfile == null) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (EqualsUtils.objectsNotEqual((Object)password, (Object)domainProfile.getDomainPassword())) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new ApiSecurityContext(securityContext, domainProfile));
        this.executionManager.getContext().setDomain(domainProfile);
    }

    private class ApiSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final DomainProfileEntity domain;

        public ApiSecurityContext(SecurityContext securityContext, DomainProfileEntity domain) {
            this.domain = domain;
            this.secure = securityContext.isSecure();
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return () -> ((DomainProfileEntity)this.domain).getDomainKey();
        }
    }
}

