/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.accounts;

import java.util.Collection;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.push.engine.accounts.AccountOperationDelegate;
import org.tiogasolutions.push.engine.accounts.AccountRequest;
import org.tiogasolutions.push.engine.accounts.AccountService;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.actions.AccountAction;
import org.tiogasolutions.push.kernel.accounts.actions.ChangePasswordAction;
import org.tiogasolutions.push.kernel.accounts.actions.ConfirmEmailAction;
import org.tiogasolutions.push.kernel.accounts.actions.CreateAccountAction;
import org.tiogasolutions.push.kernel.accounts.actions.DeleteAccountAction;
import org.tiogasolutions.push.kernel.accounts.actions.LogInAction;
import org.tiogasolutions.push.kernel.accounts.actions.ResetPasswordAction;
import org.tiogasolutions.push.kernel.accounts.actions.UpdateAccountAction;
import org.tiogasolutions.push.kernel.accounts.queries.AccountQuery;
import org.tiogasolutions.push.pub.internal.RequestErrors;

public class AccountServiceCouch
implements AccountService {
    private final AccountStore accountStore;
    private final AccountOperationDelegate accountDelegate;

    public AccountServiceCouch(AccountStore accountStore, AccountOperationDelegate accountDelegate) {
        this.accountStore = accountStore;
        this.accountDelegate = accountDelegate;
    }

    @Override
    public Account execute(AccountRequest purchaseRequest) {
        ExceptionUtils.assertNotNull((Object)purchaseRequest, (String)"request");
        AccountAction accountOperation = purchaseRequest.getOperation();
        RequestErrors errors = new RequestErrors();
        accountOperation.validate(errors);
        if (!errors.isEmpty()) {
            String msg = StringUtils.toDelineatedString((String)"\n", (Collection)errors);
            throw ApiException.badRequest((String)msg, (String[])new String[0]);
        }
        Account account = this.accountStore.get(purchaseRequest.getQuery());
        if (accountOperation instanceof ChangePasswordAction) {
            ChangePasswordAction operation = (ChangePasswordAction)accountOperation;
            return this.accountDelegate.executeOperation(account, operation);
        }
        if (accountOperation instanceof ConfirmEmailAction) {
            ConfirmEmailAction operation = (ConfirmEmailAction)accountOperation;
            return this.accountDelegate.executeOperation(account, operation);
        }
        if (accountOperation instanceof CreateAccountAction) {
            CreateAccountAction operation = (CreateAccountAction)accountOperation;
            return this.accountDelegate.executeOperation(account, operation);
        }
        if (accountOperation instanceof DeleteAccountAction) {
            DeleteAccountAction operation = (DeleteAccountAction)accountOperation;
            return this.accountDelegate.executeOperation(account);
        }
        if (accountOperation instanceof LogInAction) {
            LogInAction operation = (LogInAction)accountOperation;
            return this.accountDelegate.executeOperation(account, operation);
        }
        if (accountOperation instanceof ResetPasswordAction) {
            ResetPasswordAction operation = (ResetPasswordAction)accountOperation;
            return this.accountDelegate.executeOperation(account, operation);
        }
        if (accountOperation instanceof UpdateAccountAction) {
            UpdateAccountAction operation = (UpdateAccountAction)accountOperation;
            return this.accountDelegate.executeOperation(account, operation);
        }
        String msg = String.format("The operation %s is not supported.", accountOperation.getClass().getName());
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Account execute(AccountQuery query) {
        return this.accountStore.get(query);
    }
}

