/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.push.engine.accounts;

import java.net.URL;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.push.kernel.accounts.Account;
import org.tiogasolutions.push.kernel.accounts.AccountStore;
import org.tiogasolutions.push.kernel.accounts.actions.ChangePasswordAction;
import org.tiogasolutions.push.kernel.accounts.actions.ConfirmEmailAction;
import org.tiogasolutions.push.kernel.accounts.actions.CreateAccountAction;
import org.tiogasolutions.push.kernel.accounts.actions.LogInAction;
import org.tiogasolutions.push.kernel.accounts.actions.ResetPasswordAction;
import org.tiogasolutions.push.kernel.accounts.actions.UpdateAccountAction;

public class AccountOperationDelegate {
    private final AccountStore store;

    public AccountOperationDelegate(AccountStore store) {
        this.store = store;
    }

    public Account executeOperation(Account account, ChangePasswordAction operation) {
        account.apply(operation);
        this.store.update((Object)account);
        return account;
    }

    public Account executeOperation(Account account) {
        this.store.delete((Object)account);
        return null;
    }

    public Account executeOperation(Account account, LogInAction operation) {
        if (account == null) {
            throw ApiException.badRequest((String)"Invalid user name or password", (String[])new String[0]);
        }
        if (account.hasTempPassword()) {
            account.clearTempPassword();
            this.store.update((Object)account);
        }
        return account;
    }

    public Account executeOperation(Account account, CreateAccountAction operation) {
        if (account != null) {
            String msg = String.format("The email address \"%s\" already exists.", operation.getEmailAddress());
            throw ApiException.badRequest((String)msg, (String[])new String[0]);
        }
        account = new Account(operation);
        this.store.create((Object)account);
        return account;
    }

    public Account executeOperation(Account account, ResetPasswordAction operation) {
        if (account == null) {
            throw ApiException.badRequest((String)"The email address was not found.", (String[])new String[0]);
        }
        String tempPassword = account.createTempPassword();
        this.store.update((Object)account);
        String message = String.format("<h1 style='margin-top:0'>Password Reset</h1><p>Your temporary password for %s is %s.</p>", account.getEmailAddress(), tempPassword);
        this.sendEmail(operation.getTemplateUrl(), account.getEmailAddress(), "Password Reset", message);
        return account;
    }

    private void sendEmail(URL templateUrl, String emailAddress, String subject, String message) {
        try {
            String template = IoUtils.toString((URL)templateUrl);
            String string = template.replace("${message-content}", message);
        }
        catch (Exception e) {
            String msg = String.format("Exception sending email to %s", emailAddress);
            throw ApiException.internalServerError((String)msg, (Throwable)e, (String[])new String[0]);
        }
    }

    public Account executeOperation(Account account, ConfirmEmailAction operation) {
        account.confirmEmail(operation);
        this.store.update((Object)account);
        return account;
    }

    public Account executeOperation(Account account, UpdateAccountAction operation) {
        account.apply(operation);
        this.store.update((Object)account);
        return account;
    }
}

