/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.processor.swing;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.springframework.beans.factory.BeanFactory;
import org.tiogasolutions.notify.kernel.processor.ProcessorType;
import org.tiogasolutions.notify.kernel.processor.TaskProcessor;
import org.tiogasolutions.notify.pub.DomainProfile;
import org.tiogasolutions.notify.pub.Notification;
import org.tiogasolutions.notify.pub.Task;
import org.tiogasolutions.notify.pub.TaskResponse;

public class SwingTaskProcessor
implements TaskProcessor {
    private static final ProcessorType PROVIDER_TYPE = new ProcessorType("swing");
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd-YYYY HH:mm");
    private JFrame frame;
    private JPanel panel;
    private ArrayList<Notification> notifications = new ArrayList();

    public boolean isReady() {
        return !GraphicsEnvironment.isHeadless();
    }

    public ProcessorType getType() {
        return PROVIDER_TYPE;
    }

    public void init(BeanFactory beanFactory) {
    }

    public synchronized TaskResponse processTask(DomainProfile domainProfile, Notification notification, Task task) {
        if (this.frame == null) {
            this.createUI();
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                this.notifications.add(notification);
                while (this.notifications.size() > 50) {
                    this.notifications.remove(0);
                }
                ArrayList<Notification> copy = new ArrayList<Notification>(this.notifications);
                Collections.sort(copy, Collections.reverseOrder());
                this.panel.removeAll();
                for (Notification next : copy) {
                    this.panel.add(new JLabel(next.getCreatedAt().format(formatter) + ": " + next.getSummary()));
                }
                if (!this.frame.isVisible()) {
                    this.frame.setVisible(true);
                }
                this.frame.toFront();
                this.frame.validate();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return TaskResponse.complete((String)"Ok");
    }

    private void createUI() {
        if (this.frame != null) {
            return;
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JScrollPane scrollPane = new JScrollPane(this.panel);
        JFrame newFrame = new JFrame("Notifications");
        newFrame.getContentPane().add(scrollPane);
        newFrame.setSize(new Dimension(350, 600));
        this.frame = newFrame;
    }
}

