/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.engine.web.writers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.lib.thymeleaf.ClassPathTemplateResolver;
import org.tiogasolutions.notify.engine.web.writers.Thymeleaf;

public class ThymeleafMessageBodyWriter
implements MessageBodyWriter<Thymeleaf> {
    UriInfo uriInfo;
    private final TemplateEngine engine;

    public ThymeleafMessageBodyWriter(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        ClassPathTemplateResolver templateResolver = new ClassPathTemplateResolver();
        templateResolver.setTemplateMode("HTML5");
        templateResolver.setSuffix(".html");
        templateResolver.setPrefix("/push-server-app/view/");
        templateResolver.setCacheable(false);
        this.engine = new TemplateEngine();
        this.engine.setTemplateResolver((ITemplateResolver)templateResolver);
        this.engine.addDialect((IDialect)new Java8TimeDialect());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Thymeleaf.class.equals(type);
    }

    public long getSize(Thymeleaf thymeleaf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public String getBaseUri() {
        return this.uriInfo.getBaseUri().toASCIIString();
    }

    public void writeTo(Thymeleaf thymeleaf, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.writeTo(thymeleaf, entityStream);
    }

    public void writeTo(Thymeleaf thymeleaf, Writer writer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(thymeleaf, out);
        String text = new String(out.toByteArray(), Charset.forName("UTF-8"));
        writer.write(text);
    }

    public void writeTo(Thymeleaf thymeleaf, OutputStream outputStream) throws IOException {
        String view = thymeleaf.getView();
        org.thymeleaf.context.Context context = new org.thymeleaf.context.Context();
        context.setVariables(thymeleaf.getVariables());
        String baseUri = StringUtils.substring((Object)this.getBaseUri(), (int)0, (int)-1);
        context.setVariable("contextRoot", (Object)baseUri);
        StringWriter writer = new StringWriter();
        this.engine.process(view, (IContext)context, (Writer)writer);
        String content = writer.toString();
        outputStream.write(content.getBytes());
    }
}

