/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.security.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.domain.account.CurrentUserSource;
import org.tiogasolutions.dev.domain.account.CurrentUserStore;
import org.tiogasolutions.dev.jackson.TiogaJacksonObjectMapper;
import org.tiogasolutions.lib.security.CurrentUser;
import org.tiogasolutions.lib.security.providers.ProviderUtils;
import org.tiogasolutions.lib.security.providers.google.GoogleAuthentication;
import org.tiogasolutions.lib.security.providers.google.UserInfo;

public class GooglePlusSecurityProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log log = LogFactory.getLog(GooglePlusSecurityProvider.class);
    private final String clientSecret;
    private final String clientId;
    private final CurrentUserStore store;
    private final ObjectMapper objectMapper;

    public GooglePlusSecurityProvider(CurrentUserStore store, ObjectMapper objectMapper, String clientId, String clientSecret) {
        this.store = store;
        this.objectMapper = objectMapper;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!ProviderUtils.isGoogleAuthentication(authentication) || userDetails == null) {
            throw new BadCredentialsException("Invalid user name or password");
        }
    }

    protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            if (!ProviderUtils.isGoogleAuthentication(authentication)) {
                throw new UsernameNotFoundException("Not Goolge Authentication");
            }
            String code = authentication.getCredentials().toString();
            GoogleAuthentication googleAuth = this.getAuthResponse(code, this.clientId, this.clientSecret);
            UserInfo userInfo = GooglePlusSecurityProvider.getUserInfo(googleAuth);
            CurrentUserSource source = this.store.getCurrentUserSourceByEmail(userInfo.getEmail());
            if (source == null) {
                throw new BadCredentialsException("Invalid user name or password");
            }
            return new CurrentUser(source);
        }
        catch (IOException e) {
            throw ApiException.internalServerError((String)"Exception during Google-Authentication", (Throwable)e, (String[])new String[0]);
        }
    }

    public static UserInfo getUserInfo(GoogleAuthentication authentication) throws IOException {
        Client client = ClientBuilder.newBuilder().build();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"https://www.googleapis.com/oauth2/v1/userinfo");
        uriBuilder.queryParam("alt", new Object[]{"json"});
        uriBuilder.queryParam("access_token", new Object[]{authentication.getAccessToken()});
        Response response = client.target(uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        String json = (String)response.readEntity(String.class);
        return (UserInfo)new TiogaJacksonObjectMapper().readValue(json, UserInfo.class);
    }

    public GoogleAuthentication getAuthResponse(String code, String clientId, String clientSecret) throws IOException {
        Client client = ClientBuilder.newBuilder().build();
        Form form = new Form();
        form.param("code", code);
        form.param("client_id", clientId);
        form.param("client_secret", clientSecret);
        form.param("grant_type", "authorization_code");
        form.param("redirect_uri", "postmessage");
        UriBuilder uriBuilder = UriBuilder.fromUri((String)"https://accounts.google.com/o/oauth2/token");
        Response jerseyResponse = client.target(uriBuilder).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        int status = jerseyResponse.getStatus();
        String json = (String)jerseyResponse.readEntity(String.class);
        TiogaJacksonObjectMapper objectMapper = new TiogaJacksonObjectMapper();
        GoogleAuthentication googleAuth = (GoogleAuthentication)objectMapper.readValue(json, GoogleAuthentication.class);
        if (StringUtils.isNotBlank((Object)googleAuth.getError())) {
            String msg = String.format("Authentication Error: %s", googleAuth.getError());
            throw ApiException.internalServerError((String)msg, (String[])new String[0]);
        }
        return googleAuth;
    }
}

