/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.spring.couchace;

import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.lib.couchace.app.AppConfig;
import org.tiogasolutions.lib.couchace.app.AppConfigStore;

public class CouchResourceLoader
implements ResourceLoader {
    private final AppConfigStore store;

    public CouchResourceLoader(AppConfigStore store) {
        this.store = store;
    }

    public CouchResourceLoader(CouchServer couchServer) {
        this(new AppConfigStore(couchServer));
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Resource getResource(String entityName) {
        AppConfig appConfig = (AppConfig)this.store.getByDocumentId(entityName);
        if (appConfig == null) {
            String msg = String.format("The application-configuration entity \"%s\" is missing from the \"%s\" database.", entityName, this.store.getDatabase().getDatabaseName());
            throw new UnsupportedOperationException(msg);
        }
        String content = appConfig.getPropertyString();
        byte[] bytes = content.getBytes();
        return new ByteArrayResource(bytes, entityName);
    }
}

