/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.spring.couchace;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.lib.couchace.DefaultCouchServer;
import org.tiogasolutions.lib.couchace.app.AppConfigStore;
import org.tiogasolutions.lib.spring.couchace.CouchResourceLoader;

public class CouchPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private final Resource[] resources = new Resource[1];

    public CouchPropertyPlaceholderConfigurer(CouchServer couchServer, String entityName) throws MalformedURLException, URISyntaxException {
        this(couchServer, "app-config", entityName);
    }

    public CouchPropertyPlaceholderConfigurer(String entityName) throws MalformedURLException, URISyntaxException {
        this((CouchServer)new DefaultCouchServer(), "app-config", entityName);
    }

    public CouchPropertyPlaceholderConfigurer(CouchServer couchServer, String databaseName, String entityName) throws MalformedURLException, URISyntaxException {
        ExceptionUtils.assertNotNull((Object)couchServer, (String)"couchServer");
        ExceptionUtils.assertNotNull((Object)entityName, (String)"entityName");
        AppConfigStore store = new AppConfigStore(couchServer, databaseName);
        CouchResourceLoader loader = new CouchResourceLoader(store);
        this.resources[0] = loader.getResource(entityName);
    }

    public void setLocations(Resource[] resources) {
        System.out.printf("", new Object[0]);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        super.setLocations(this.resources);
        super.postProcessBeanFactory(beanFactory);
    }

    protected void loadProperties(Properties props) throws IOException {
        super.loadProperties(props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("system.")) continue;
            key = key.substring(7);
            System.setProperty(key, (String)entry.getValue());
        }
    }
}

