/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.tiogasolutions.jobs.pub.ActionType;
import org.tiogasolutions.jobs.pub.JobAction;

public class OsAction
implements JobAction {
    private final String command;
    private final File workingDirectory;
    private final String lock;
    private final long timeout;
    private final TimeUnit timeoutUnit;

    @JsonCreator
    private OsAction(@JsonProperty(value="command") String command, @JsonProperty(value="workingDirectory") String dir, @JsonProperty(value="lock") String lock, @JsonProperty(value="timeout") long timeout, @JsonProperty(value="timeoutUnit") TimeUnit timeoutUnit) {
        this.command = command;
        this.workingDirectory = (dir == null ? new File("") : new File(dir)).getAbsoluteFile();
        this.lock = lock;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    @Override
    @JsonIgnore
    public ActionType getActionType() {
        return ActionType.osCommand;
    }

    public String getCommand() {
        return this.command;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public String getLock() {
        return this.lock;
    }

    @Override
    public String getLabel() {
        return String.format("OS Command [%s]", this.command);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public static OsAction newAction(String command, File workingDirectory, String lock, long timeout, TimeUnit timeoutUnit) {
        return new OsAction(command, workingDirectory.getAbsolutePath(), lock, timeout, timeoutUnit);
    }

    public static OsAction newAction(String command, Path workingDirectory, String lock, long timeout, TimeUnit timeoutUnit) {
        return new OsAction(command, workingDirectory.toFile().getAbsolutePath(), lock, timeout, timeoutUnit);
    }
}

