/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.kernel.entities;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.jobs.kernel.config.CouchServersConfig;
import org.tiogasolutions.jobs.kernel.entities.DomainProfileEntity;
import org.tiogasolutions.jobs.kernel.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.kernel.support.ExecutionContextManager;
import org.tiogasolutions.jobs.kernel.support.JobsCouchServer;
import org.tiogasolutions.lib.couchace.DefaultCouchStore;

@Component
public class JobExecutionRequestStore
extends DefaultCouchStore<JobExecutionRequestEntity> {
    public static final String JOB_EXECUTION_REQUEST_DESIGN_NAME = "jobExecutionRequest";
    private final CouchServersConfig config;
    private final ExecutionContextManager ecm;

    @Autowired
    public JobExecutionRequestStore(CouchServersConfig config, ExecutionContextManager ecm) {
        super((CouchServer)JobsCouchServer.newDomainDb(config), JobExecutionRequestEntity.class);
        this.ecm = ecm;
        this.config = config;
    }

    public String getDesignName() {
        return JOB_EXECUTION_REQUEST_DESIGN_NAME;
    }

    public String getDatabaseName() {
        DomainProfileEntity domainProfile = this.ecm.getExecutionContext().getDomainProfileEntity();
        return this.config.getDomainDatabasePrefix() + domainProfile.getDomainName().toLowerCase();
    }

    public JobsCouchServer getCouchServer() {
        return (JobsCouchServer)super.getCouchServer();
    }

    public void createDatabase(CouchDatabase database) {
        this.config.createDatabase(database);
    }

    public List<JobExecutionRequestEntity> getAll() {
        return this.getEntityResponse("entity", "byEntityType", Collections.singletonList(JOB_EXECUTION_REQUEST_DESIGN_NAME)).getEntityList();
    }
}

