/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.kernel.entities;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.jobs.kernel.entities.CouchServersConfig;
import org.tiogasolutions.jobs.kernel.entities.DomainProfileEntity;
import org.tiogasolutions.jobs.kernel.entities.JobDefinitionEntity;
import org.tiogasolutions.jobs.kernel.support.ExecutionContextManager;
import org.tiogasolutions.jobs.kernel.support.JobsCouchServer;
import org.tiogasolutions.lib.couchace.DefaultCouchStore;

@Named
public class JobDefinitionStore
extends DefaultCouchStore<JobDefinitionEntity> {
    public static final String JOB_DEFINITION_DESIGN_NAME = "jobDefinition";
    private final CouchServersConfig config;
    private final ExecutionContextManager ecm;

    @Inject
    public JobDefinitionStore(CouchServersConfig config, ExecutionContextManager ecm) {
        super((CouchServer)JobsCouchServer.newDomainDb(config), JobDefinitionEntity.class);
        this.ecm = ecm;
        this.config = config;
    }

    public String getDesignName() {
        return JOB_DEFINITION_DESIGN_NAME;
    }

    public String getDatabaseName() {
        DomainProfileEntity domainProfile = this.ecm.getExecutionContext().getDomainProfileEntity();
        return this.config.getDomainDatabasePrefix() + domainProfile.getDomainName().toLowerCase() + this.config.getDomainDatabaseSuffix();
    }

    public JobsCouchServer getCouchServer() {
        return (JobsCouchServer)super.getCouchServer();
    }

    public void createDatabase(CouchDatabase database) {
        this.config.createDatabase(database);
    }

    public List<JobDefinitionEntity> getAll() {
        return this.getEntityResponse("entity", "byEntityType", Collections.singletonList(JOB_DEFINITION_DESIGN_NAME)).getEntityList();
    }
}

