/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.tiogasolutions.dev.common.json.JsonTranslator;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.dev.jackson.TiogaJacksonTranslator;
import org.tiogasolutions.jobs.client.JobsServerClient;
import org.tiogasolutions.jobs.jackson.JobsObjectMapper;
import org.tiogasolutions.jobs.pub.JobDefinition;
import org.tiogasolutions.jobs.pub.JobExecutionRequest;
import org.tiogasolutions.jobs.pub.JobParameters;
import org.tiogasolutions.lib.jaxrs.jackson.SimpleRestClient;

public class LiveJobsServerClient
implements JobsServerClient {
    private final SimpleRestClient client;

    public LiveJobsServerClient(String userName, String password, URI uri) {
        JobsObjectMapper objectMapper = new JobsObjectMapper();
        TiogaJacksonTranslator translator = new TiogaJacksonTranslator((ObjectMapper)objectMapper);
        this.client = new SimpleRestClient((JsonTranslator)translator, uri.toASCIIString(), userName, password);
    }

    public LiveJobsServerClient(SimpleRestClient client) {
        this.client = client;
    }

    public QueryResult<JobDefinition> getJobs() {
        String path = "/client/jobs";
        return (QueryResult)this.client.get(QueryResult.class, path, new String[0]);
    }

    public JobDefinition getJob(String jobId) {
        String path = String.format("/client/jobs/%s", jobId);
        return (JobDefinition)this.client.get(JobDefinition.class, path, new String[0]);
    }

    public JobExecutionRequest start(String jobId, JobParameters parameters) {
        String path = String.format("/client/jobs/%s", jobId);
        return (JobExecutionRequest)this.client.post(JobExecutionRequest.class, path, (Object)parameters);
    }
}

