/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZonedDateTime;

public class JobActionResult {
    private final int exitValue;
    private final String out;
    private final String err;
    private final String command;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime completedAt;

    @JsonCreator
    private JobActionResult(@JsonProperty(value="command") String command, @JsonProperty(value="exitValue") int exitValue, @JsonProperty(value="out") String out, @JsonProperty(value="err") String err, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="completedAt") ZonedDateTime completedAt) {
        this.exitValue = exitValue;
        this.command = command;
        this.createdAt = createdAt;
        this.completedAt = completedAt;
        this.out = out == null ? null : out.replace("\r", "");
        this.err = err == null ? null : err.replace("\r", "");
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getCompletedAt() {
        return this.completedAt;
    }

    public String getCommand() {
        return this.command;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getOut() {
        return this.out;
    }

    public String getErr() {
        return this.err;
    }

    public static JobActionResult finished(String command, ZonedDateTime createdAt, int exitValue, String out, String err) {
        return new JobActionResult(command, exitValue, out, err, createdAt, ZonedDateTime.now());
    }

    public static JobActionResult fail(String command, ZonedDateTime createdAt, Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString();
        return new JobActionResult(command, Integer.MIN_VALUE, null, stackTrace, createdAt, ZonedDateTime.now());
    }

    public boolean isFailure() {
        return this.exitValue != 0;
    }
}

