/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.couchace.annotations.CouchAttachmentInfoMap;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchException;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.meta.CouchEmbeddedAttachmentMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchEntityMeta;
import org.tiogasolutions.couchace.core.api.meta.CouchMetaRepository;
import org.tiogasolutions.couchace.core.api.request.DeleteAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.DeleteDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.DeleteEntityRequest;
import org.tiogasolutions.couchace.core.api.request.DeleteRequest;
import org.tiogasolutions.couchace.core.api.request.GetAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.GetDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.GetDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.GetEntityRequest;
import org.tiogasolutions.couchace.core.api.request.HeadRequest;
import org.tiogasolutions.couchace.core.api.request.PostDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.PostDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.PostEntityRequest;
import org.tiogasolutions.couchace.core.api.request.PostRequest;
import org.tiogasolutions.couchace.core.api.request.PutAttachmentRequest;
import org.tiogasolutions.couchace.core.api.request.PutDatabaseRequest;
import org.tiogasolutions.couchace.core.api.request.PutDesignRequest;
import org.tiogasolutions.couchace.core.api.request.PutDocumentRequest;
import org.tiogasolutions.couchace.core.api.request.PutEntityRequest;
import org.tiogasolutions.couchace.core.api.request.PutRequest;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.GetAttachmentResponse;
import org.tiogasolutions.couchace.core.api.response.GetContentResponse;
import org.tiogasolutions.couchace.core.api.response.GetDocumentResponse;
import org.tiogasolutions.couchace.core.api.response.GetEntityResponse;
import org.tiogasolutions.couchace.core.api.response.HeadResponse;
import org.tiogasolutions.couchace.core.api.response.TextDocument;
import org.tiogasolutions.couchace.core.api.response.WriteResponse;
import org.tiogasolutions.couchace.core.internal.GetResponseBuilder;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;
import org.tiogasolutions.couchace.core.spi.http.HttpDeleteRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpGetRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpHeadRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpPostRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpPutRequest;
import org.tiogasolutions.couchace.core.spi.http.HttpRequestFactory;

public class RequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(RequestExecutor.class);
    private final CouchDatabase couch;
    private final CouchHttpClient httpClient;
    private final HttpRequestFactory httpRequestFactory;
    private final GetResponseBuilder getResponseBuilder;
    private final CouchMetaRepository metaRepository;

    public RequestExecutor(CouchDatabase couch) {
        this.couch = couch;
        this.httpClient = couch.getHttpClient();
        this.metaRepository = couch.getMetaRepository();
        this.httpRequestFactory = new HttpRequestFactory(couch.getDatabaseName(), couch.getJsonStrategy());
        this.getResponseBuilder = new GetResponseBuilder(couch);
    }

    public HeadResponse execute(HeadRequest request) {
        HttpHeadRequest httpHeadRequest = this.httpRequestFactory.newHttpHeadRequest(request);
        CouchHttpResponse httpResponse = this.httpClient.head(httpHeadRequest);
        return new HeadResponse(httpResponse);
    }

    public GetDocumentResponse execute(GetDocumentRequest request) {
        HttpGetRequest httpGetRequest = this.httpRequestFactory.newHttpGetRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.get(httpGetRequest);
        return this.getResponseBuilder.buildDocumentResponse(request, couchHttpResponse);
    }

    public GetContentResponse execute(GetDatabaseRequest request) {
        HttpGetRequest httpGetRequest = this.httpRequestFactory.newHttpGetRequest(request);
        CouchHttpResponse httpResponse = this.httpClient.get(httpGetRequest);
        CouchErrorContent errorContent = CouchErrorContent.noError;
        if (httpResponse.isError() && httpResponse.getContentType() == CouchMediaType.APPLICATION_JSON) {
            errorContent = CouchErrorContent.parseJson(httpResponse.getStringContent());
        }
        return new GetContentResponse(httpResponse.getUri(), httpResponse.getHttpStatus(), httpResponse.getContentType(), httpResponse.getContent(), errorContent);
    }

    public GetAttachmentResponse execute(GetAttachmentRequest request) {
        GetAttachmentResponse response;
        HttpGetRequest httpGetRequest = this.httpRequestFactory.newHttpGetRequest(request);
        CouchHttpResponse httpResponse = this.httpClient.get(httpGetRequest);
        CouchErrorContent errorContent = CouchErrorContent.noError;
        if (httpResponse.isError() && httpResponse.getContentType() == CouchMediaType.APPLICATION_JSON) {
            errorContent = CouchErrorContent.parseJson(httpResponse.getStringContent());
        }
        if ((response = new GetAttachmentResponse(httpResponse.getUri(), httpResponse.getHttpStatus(), httpResponse.getDocumentId(), httpResponse.getEtag(), httpResponse.getContentType(), httpResponse.getContent(), errorContent)).isError() && request.getOnError() != null) {
            request.getOnError().handle(response);
        } else if (request.getOnSuccess() != null) {
            request.getOnSuccess().handle(response);
        }
        if (request.getOnResponse() != null) {
            request.getOnResponse().handle(response);
        }
        return response;
    }

    public <T> GetEntityResponse<T> execute(GetEntityRequest<T> request) {
        HttpGetRequest httpGetRequest = this.httpRequestFactory.newHttpGetRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.get(httpGetRequest);
        GetEntityResponse<T> response = this.getResponseBuilder.buildEntityResponse(request, couchHttpResponse);
        if (response.isError() && request.getOnError() != null) {
            request.getOnError().handle(response);
        } else if (request.getOnSuccess() != null) {
            request.getOnSuccess().handle(response);
        }
        if (request.getOnResponse() != null) {
            request.getOnResponse().handle(response);
        }
        return response;
    }

    public WriteResponse execute(PutRequest request) {
        WriteResponse response;
        if (request instanceof PutEntityRequest) {
            response = this.executePutEntity((PutEntityRequest)request);
        } else if (request instanceof PutDocumentRequest) {
            response = this.executePutDocument((PutDocumentRequest)request);
        } else if (request instanceof PutAttachmentRequest) {
            response = this.executePutAttachment((PutAttachmentRequest)request);
        } else if (request instanceof PutDesignRequest) {
            response = this.executePutDesign((PutDesignRequest)request);
        } else if (request instanceof PutDatabaseRequest) {
            response = this.executePutDatabase((PutDatabaseRequest)request);
        } else {
            String className = request == null ? "null" : request.getClass().getName();
            String msg = String.format("The request %s is not supported.", className);
            throw new UnsupportedOperationException(msg);
        }
        if (response.isError() && request.getOnError() != null) {
            request.getOnError().handle(response);
        } else if (request.getOnSuccess() != null) {
            request.getOnSuccess().handle(response);
        }
        if (request.getOnResponse() != null) {
            request.getOnResponse().handle(response);
        }
        return response;
    }

    protected WriteResponse executePutEntity(PutEntityRequest request) {
        HttpPutRequest httpPutRequest;
        CouchHttpResponse couchHttpResponse;
        CouchEntityMeta<?> entityMeta = this.metaRepository.getOrCreateEntityMeta(request.getEntityClass());
        if (request.getDocumentId() == null && request.getDocumentRevision() == null) {
            if (entityMeta.hasId()) {
                Object entity = request.getEntity();
                String id = entityMeta.readDocumentId(entity);
                String revision = entityMeta.readDocumentRevision(entity);
                String entityType = entityMeta.getEntityType();
                CouchAttachmentInfoMap attachmentInfoMap = entityMeta.readAttachmentInfoMap(entity);
                request = revision != null ? this.couch.put().entity(id, entityType, entity, revision, attachmentInfoMap) : this.couch.put().entity(id, entityType, entity, attachmentInfoMap);
            } else {
                throw CouchException.internalServerError("Cannot build PutEntityRequest for entity " + request.getEntityClass() + ", @CouchId is not specified.");
            }
        }
        if ((couchHttpResponse = this.httpClient.put(httpPutRequest = this.httpRequestFactory.newHttpPutRequest(request))).isSuccess() && entityMeta.hasEmbeddedAttachments()) {
            couchHttpResponse = this.writeEntityAttachments(entityMeta, couchHttpResponse, request.getEntity());
        }
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executePutDocument(PutDocumentRequest request) {
        HttpPutRequest httpPutRequest = this.httpRequestFactory.newHttpPutRequest(request);
        return new WriteResponse(this.httpClient.put(httpPutRequest));
    }

    protected WriteResponse executePutAttachment(PutAttachmentRequest request) {
        HttpPutRequest httpPutRequest = this.httpRequestFactory.newHttpPutRequest(request);
        return new WriteResponse(this.httpClient.put(httpPutRequest));
    }

    protected WriteResponse executePutDesign(PutDesignRequest request) {
        HttpPutRequest httpPutRequest = this.httpRequestFactory.newHttpPutRequest(request);
        return new WriteResponse(this.httpClient.put(httpPutRequest));
    }

    protected WriteResponse executePutDatabase(PutDatabaseRequest request) {
        HttpPutRequest httpPutRequest = this.httpRequestFactory.newHttpPutRequest(request);
        return new WriteResponse(this.httpClient.put(httpPutRequest));
    }

    public WriteResponse execute(PostRequest request) {
        if (request instanceof PostEntityRequest) {
            return this.executePostEntity((PostEntityRequest)request);
        }
        if (request instanceof PostDocumentRequest) {
            return this.executePostDocument((PostDocumentRequest)request);
        }
        if (request instanceof PostDatabaseRequest) {
            return this.executePostDatabase((PostDatabaseRequest)request);
        }
        String className = request == null ? "null" : request.getClass().getName();
        String msg = String.format("The request %s is not supported.", className);
        throw new UnsupportedOperationException(msg);
    }

    protected WriteResponse executePostEntity(PostEntityRequest request) {
        CouchEntityMeta<?> entityMeta = this.metaRepository.getOrCreateEntityMeta(request.getEntityClass());
        HttpPostRequest httpPostRequest = this.httpRequestFactory.newHttpPostRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.post(httpPostRequest);
        if (couchHttpResponse.isSuccess() && entityMeta.hasEmbeddedAttachments()) {
            couchHttpResponse = this.writeEntityAttachments(entityMeta, couchHttpResponse, request.getEntity());
        }
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executePostDocument(PostDocumentRequest request) {
        HttpPostRequest httpPostRequest = this.httpRequestFactory.newHttpPostRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.post(httpPostRequest);
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executePostDatabase(PostDatabaseRequest request) {
        HttpPostRequest httpPostRequest = this.httpRequestFactory.newHttpPostRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.post(httpPostRequest);
        return new WriteResponse(couchHttpResponse);
    }

    public WriteResponse execute(DeleteRequest request) {
        if (request instanceof DeleteEntityRequest) {
            return this.executeDeleteEntity((DeleteEntityRequest)request);
        }
        if (request instanceof DeleteAttachmentRequest) {
            return this.executeDeleteAttachment((DeleteAttachmentRequest)request);
        }
        if (request instanceof DeleteDocumentRequest) {
            DeleteDocumentRequest deleteRequest = (DeleteDocumentRequest)request;
            if (deleteRequest.getType() == DeleteDocumentRequest.Type.DOCUMENT) {
                return this.executeDeleteDocument(deleteRequest);
            }
            if (deleteRequest.getType() == DeleteDocumentRequest.Type.DATABASE) {
                return this.executeDeleteDatabase(deleteRequest);
            }
            if (deleteRequest.getType() == DeleteDocumentRequest.Type.ALL_DOCUMENTS) {
                return this.executeDeleteAllDocuments();
            }
            if (deleteRequest.getType() == DeleteDocumentRequest.Type.ALL_DESIGNS) {
                return this.executeDeleteAllDesigns();
            }
            if (deleteRequest.getType() == DeleteDocumentRequest.Type.ALL_NON_DESIGNS) {
                return this.executeDeleteAllNonDesigns();
            }
            throw CouchException.badRequest("Unsupported DeleteRequestType " + (Object)((Object)deleteRequest.getType()));
        }
        String className = request == null ? "null" : request.getClass().getName();
        String msg = String.format("The request %s is not supported.", className);
        throw CouchException.badRequest(msg);
    }

    protected WriteResponse executeDeleteEntity(DeleteEntityRequest request) {
        CouchEntityMeta<?> entityMeta = this.metaRepository.getOrCreateEntityMeta(request.getEntityClass());
        if (!entityMeta.hasId()) {
            throw CouchException.internalServerError("Cannot build DeleteEntityRequest for entity " + request.getEntityClass() + ", @CouchId is not specified.");
        }
        Object entity = request.getEntity();
        String id = entityMeta.readDocumentId(entity);
        String revision = entityMeta.readDocumentRevision(entity);
        DeleteDocumentRequest deleteDocumentRequest = this.couch.delete().document(id, revision);
        HttpDeleteRequest httpDeleteRequest = this.httpRequestFactory.newHttpDeleteRequest(deleteDocumentRequest);
        CouchHttpResponse couchHttpResponse = this.httpClient.delete(httpDeleteRequest);
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executeDeleteAttachment(DeleteAttachmentRequest request) {
        HttpDeleteRequest httpDeleteRequest = this.httpRequestFactory.newHttpDeleteRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.delete(httpDeleteRequest);
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executeDeleteDocument(DeleteDocumentRequest request) {
        HttpDeleteRequest httpDeleteRequest = this.httpRequestFactory.newHttpDeleteRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.delete(httpDeleteRequest);
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executeDeleteDatabase(DeleteDocumentRequest request) {
        HttpDeleteRequest httpDeleteRequest = this.httpRequestFactory.newHttpDeleteRequest(request);
        CouchHttpResponse couchHttpResponse = this.httpClient.delete(httpDeleteRequest);
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executeDeleteAllDocuments() {
        String path = "_all_docs";
        GetDocumentResponse getResponse = new GetDocumentRequest(this, path, null).execute();
        for (TextDocument document : getResponse) {
            String revision;
            String id = document.getDocumentId();
            WriteResponse deleteResponse = new DeleteDocumentRequest(this, DeleteDocumentRequest.Type.DOCUMENT, id, revision = document.getDocumentRevision()).execute();
            if (!deleteResponse.isError()) continue;
            throw new CouchException(deleteResponse.getHttpStatus(), "Error deleting design document " + id);
        }
        CouchHttpResponse couchHttpResponse = CouchHttpResponse.builder(CouchMethodType.DELETE, this.httpClient.uri(path), CouchHttpStatus.OK).build();
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executeDeleteAllDesigns() {
        String path = "/_all_docs?startkey=%22_design/%22&endkey=%22_design0%22";
        GetDocumentResponse getResponse = new GetDocumentRequest(this, path, null).execute();
        for (TextDocument document : getResponse) {
            String revision;
            WriteResponse deleteResponse;
            String id = document.getDocumentId();
            if (!id.startsWith("_design") || !(deleteResponse = new DeleteDocumentRequest(this, DeleteDocumentRequest.Type.DOCUMENT, id, revision = document.getDocumentRevision()).execute()).isError()) continue;
            throw new CouchException(deleteResponse.getHttpStatus(), "Error deleting design document " + id);
        }
        CouchHttpResponse couchHttpResponse = CouchHttpResponse.builder(CouchMethodType.DELETE, this.httpClient.uri(path), CouchHttpStatus.OK).build();
        return new WriteResponse(couchHttpResponse);
    }

    protected WriteResponse executeDeleteAllNonDesigns() {
        String path = "_all_docs";
        GetDocumentResponse getResponse = new GetDocumentRequest(this, path, null).execute();
        for (TextDocument document : getResponse) {
            String revision;
            WriteResponse deleteResponse;
            String id = document.getDocumentId();
            if (id == null || id.startsWith("_design") || !(deleteResponse = new DeleteDocumentRequest(this, DeleteDocumentRequest.Type.DOCUMENT, id, revision = document.getDocumentRevision()).execute()).isError()) continue;
            String msg = String.format("Error deleting document %s rev(%s) - %s", id, revision, deleteResponse.getErrorReason());
            throw new CouchException(deleteResponse.getHttpStatus(), msg);
        }
        CouchHttpResponse couchHttpResponse = CouchHttpResponse.builder(CouchMethodType.DELETE, this.httpClient.uri(path), CouchHttpStatus.OK).build();
        return new WriteResponse(couchHttpResponse);
    }

    protected CouchHttpResponse writeEntityAttachments(CouchEntityMeta<?> entityMeta, CouchHttpResponse couchHttpResponse, Object entity) {
        for (CouchEmbeddedAttachmentMeta attachmentMeta : entityMeta.getEmbeddedAttachmentMetaList()) {
            try {
                Object value = attachmentMeta.readValue(entity);
                if (value == null) continue;
                couchHttpResponse = this.writeAttachment(attachmentMeta, couchHttpResponse.getDocumentId(), couchHttpResponse.getEtag(), value);
            }
            catch (CouchException e) {
                log.error("Exception writing entity attachment: " + e.getMessage(), (Throwable)e);
                throw new CouchException(CouchHttpStatus.INTERNAL_SERVER_ERROR, "Exception saving attachment: " + e.getMessage(), (Throwable)e);
            }
        }
        return couchHttpResponse;
    }

    protected CouchHttpResponse writeAttachment(CouchEmbeddedAttachmentMeta attachmentMeta, String documentId, String revision, Object content) {
        PutAttachmentRequest putAttachmentRequest = new PutAttachmentRequest(this, documentId, revision, attachmentMeta.getAttachmentName(), attachmentMeta.getContentType(), content);
        CouchHttpResponse couchHttpResponse = this.httpClient.put(this.httpRequestFactory.newHttpPutRequest(putAttachmentRequest));
        if (couchHttpResponse.isError()) {
            CouchErrorContent errorContent = CouchErrorContent.parseJson(couchHttpResponse.getStringContent());
            String msg = String.format("Store of document successful but failed in storage of attachment with status: %s and error content: %s", couchHttpResponse.getHttpStatus().getReason(), errorContent.toString());
            throw new CouchException(couchHttpResponse.getHttpStatus(), msg);
        }
        return couchHttpResponse;
    }
}

