/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.app.logging;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class LogUtils {
    public static final Level DEFAULT_LEVEL = Level.WARN;
    public static final String DEFAULT_PATTERN = "%-5p: %d{MM-dd-yy HH:mm:ss} [%t] %c %x- %m%n";

    public void initAppenders(File logFile) {
        this.initConsoleAppender(DEFAULT_LEVEL, DEFAULT_PATTERN);
        this.initDailyRollingFileAppender(DEFAULT_LEVEL, DEFAULT_PATTERN, logFile);
    }

    public void initConsoleAppender() {
        this.initConsoleAppender(DEFAULT_LEVEL, DEFAULT_PATTERN);
    }

    public void initConsoleAppender(Level level, String pattern) {
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout(pattern));
        consoleAppender.setThreshold((Priority)level);
        Logger.getRootLogger().addAppender((Appender)consoleAppender);
        String msg = String.format("%s configured with log level %s.", ConsoleAppender.class.getSimpleName(), level);
        this.info(LogUtils.class, msg);
    }

    public void initDailyRollingFileAppender(File logFile) {
        this.initDailyRollingFileAppender(DEFAULT_LEVEL, DEFAULT_PATTERN, logFile);
    }

    public void initDailyRollingFileAppender(Level level, String pattern, File logFile) {
        try {
            if (logFile.getParentFile().exists()) {
                DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)new PatternLayout(pattern), logFile.getAbsolutePath(), "yyyy-MM-dd");
                fileAppender.setThreshold((Priority)level);
                Logger.getRootLogger().addAppender((Appender)fileAppender);
                String msg = String.format("%s configured with log level %s appending to %s.", DailyRollingFileAppender.class.getSimpleName(), level, logFile.getAbsolutePath());
                this.info(LogUtils.class, msg);
            } else {
                String msg = String.format("Unable to configure %s, file not found: %s", DailyRollingFileAppender.class.getSimpleName(), logFile.getParentFile().getAbsolutePath());
                this.fatal(LogUtils.class, msg);
            }
        }
        catch (IOException ex) {
            this.fatal(LogUtils.class, "Unable to configure " + DailyRollingFileAppender.class.getSimpleName(), ex);
        }
    }

    public void info(Class type, String msg) {
        Logger.getLogger((Class)type).info((Object)msg);
    }

    public void info(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).info((Object)msg, ex);
    }

    public void warn(Class type, String msg) {
        Logger.getLogger((Class)type).warn((Object)msg);
    }

    public void warn(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).warn((Object)msg, ex);
    }

    public void fatal(Class type, String msg) {
        Logger.getLogger((Class)type).fatal((Object)msg);
    }

    public void fatal(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).fatal((Object)msg, ex);
    }

    public void trace(Class type, String msg) {
        Logger.getLogger((Class)type).trace((Object)msg);
    }

    public void trace(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).trace((Object)msg, ex);
    }

    public void debug(Class type, String msg) {
        Logger.getLogger((Class)type).debug((Object)msg);
    }

    public void debug(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).debug((Object)msg, ex);
    }
}

