/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.pub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JobActionResult {
    private final int exitValue;
    private final String out;
    private final String err;
    private final String command;

    @JsonCreator
    private JobActionResult(@JsonProperty(value="command") String command, @JsonProperty(value="exitValue") int exitValue, @JsonProperty(value="out") String out, @JsonProperty(value="err") String err) {
        this.exitValue = exitValue;
        this.command = command;
        this.out = out == null ? null : out.replace("\r", "");
        this.err = err == null ? null : err.replace("\r", "");
    }

    public String getCommand() {
        return this.command;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getOut() {
        return this.out;
    }

    public String getErr() {
        return this.err;
    }

    public static JobActionResult finished(String command, int exitValue, String out, String err) {
        return new JobActionResult(command, exitValue, out, err);
    }

    public static JobActionResult fail(String command, Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString();
        return new JobActionResult(command, Integer.MIN_VALUE, null, stackTrace);
    }

    public boolean isFailure() {
        return this.exitValue != 0;
    }
}

