/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.DatatypeConverter;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.jobs.agent.JobsApplication;
import org.tiogasolutions.jobs.agent.entities.DomainProfileEntity;
import org.tiogasolutions.jobs.agent.entities.DomainProfileStore;
import org.tiogasolutions.jobs.agent.support.ExecutionContextManager;
import org.tiogasolutions.jobs.pub.DomainProfile;

@PreMatching
@Priority(value=1000)
public class JobsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private UriInfo uriInfo;
    private Application app;

    @Context
    private void init(Application app, UriInfo uriInfo) {
        this.app = app;
        this.uriInfo = uriInfo;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String baseUri = this.uriInfo.getBaseUri().toString();
        String requestUri = this.uriInfo.getRequestUri().toString();
        String path = requestUri.substring(baseUri.length() - 1);
        Map properties = this.app.getProperties();
        String clientContext = ExceptionUtils.assertNotZeroLength((String)((String)properties.get("app.client.context")), (String)"app.client.context");
        String adminContext = ExceptionUtils.assertNotZeroLength((String)((String)properties.get("app.admin.context")), (String)"app.admin.context");
        if (path.equals(clientContext) || path.startsWith(clientContext + "/")) {
            this.authenticateClientRequest(requestContext);
        } else if (path.equals(adminContext) || path.startsWith(adminContext + "/")) {
            this.authenticateAdminRequest(requestContext);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        JobsApplication.get(this.app, ExecutionContextManager.class).clearContext();
    }

    private void authenticateClientRequest(ContainerRequestContext requestContext) {
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"Notify", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        String apiUsername = basicAuth.substring(0, pos);
        String apiPassword = basicAuth.substring(pos + 1);
        if (StringUtils.isBlank((Object)apiUsername) || StringUtils.isBlank((Object)apiPassword)) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        DomainProfileStore store = (DomainProfileStore)((Object)this.app.getProperties().get(DomainProfileStore.class.getName()));
        DomainProfileEntity domainProfile = store.getByApiKey(apiUsername);
        if (domainProfile == null) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (EqualsUtils.objectsNotEqual((Object)apiPassword, (Object)domainProfile.getApiPassword())) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new ClientSecurityContext(securityContext, domainProfile.toDomainProfile()));
        JobsApplication.get(this.app, ExecutionContextManager.class).create(domainProfile);
    }

    private void authenticateAdminRequest(ContainerRequestContext requestContext) {
        String password;
        String username;
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (!authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            username = basicAuth;
            password = null;
        } else {
            username = basicAuth.substring(0, pos);
            password = basicAuth.substring(pos + 1);
        }
        this.authorize(username, password);
        SecurityContext securityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext((SecurityContext)new AdminSecurityContext(securityContext, username));
    }

    private void authorize(String username, String password) {
        if (!"admin".equals(username) || !password.equals("North2South!")) {
            throw new NotAuthorizedException((Object)"ADMIN", new Object[0]);
        }
    }

    private class ClientSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final String domainName;
        private final Principal principal;

        public ClientSecurityContext(SecurityContext securityContext, DomainProfile domain) {
            this.secure = securityContext.isSecure();
            this.domainName = domain.getDomainName();
            this.principal = this::getDomainName;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }
    }

    private class AdminSecurityContext
    implements SecurityContext {
        private final boolean secure;
        private final String username;

        public AdminSecurityContext(SecurityContext securityContext, String username) {
            this.username = username;
            this.secure = securityContext.isSecure();
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getAuthenticationScheme() {
            return "BASIC_AUTH";
        }

        public Principal getUserPrincipal() {
            return this::getUsername;
        }
    }
}

