/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.entities;

import java.util.Collections;
import java.util.List;
import org.tiogasolutions.couchace.core.api.CouchDatabase;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.jobs.agent.entities.DomainDatabaseConfig;
import org.tiogasolutions.jobs.agent.entities.DomainProfileEntity;
import org.tiogasolutions.jobs.agent.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.agent.support.JobsCouchServer;
import org.tiogasolutions.lib.couchace.DefaultCouchStore;

public class JobExecutionRequestStore
extends DefaultCouchStore<JobExecutionRequestEntity> {
    public static final String JOB_EXECUTION_REQUEST_DESIGN_NAME = "jobExecutionRequest";
    private final DomainDatabaseConfig config;

    public JobExecutionRequestStore(DomainDatabaseConfig config) {
        super((CouchServer)config.getCouchServer(), JobExecutionRequestEntity.class);
        this.config = config;
    }

    public String getDesignName() {
        return JOB_EXECUTION_REQUEST_DESIGN_NAME;
    }

    public String getDatabaseName() {
        DomainProfileEntity domainProfile = this.config.getEcm().getExecutionContext().getDomainProfileEntity();
        return this.config.getDbNamePrefix() + domainProfile.getDomainName().toLowerCase() + this.config.getDbNameSuffix();
    }

    public JobsCouchServer getCouchServer() {
        return (JobsCouchServer)super.getCouchServer();
    }

    public void createDatabase(CouchDatabase database) {
        this.config.createDatabase(database);
    }

    public List<JobExecutionRequestEntity> getAll() {
        return this.getEntityResponse("entity", "byEntityType", Collections.singletonList(JOB_EXECUTION_REQUEST_DESIGN_NAME)).getEntityList();
    }
}

