/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tiogasolutions.couchace.annotations.CouchEntity;
import org.tiogasolutions.couchace.annotations.CouchId;
import org.tiogasolutions.couchace.annotations.CouchRevision;
import org.tiogasolutions.dev.common.id.uuid.TimeUuid;
import org.tiogasolutions.jobs.agent.entities.JobDefinitionEntity;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.JobExecutionRequest;
import org.tiogasolutions.jobs.pub.JobParameters;

@CouchEntity(value="jobExecutionRequest")
public class JobExecutionRequestEntity {
    private final String jobExecutionRequestId;
    private final String revision;
    private final String jobDefinitionId;
    private final JobParameters jobParameters;
    private final List<JobActionResult> results = new ArrayList<JobActionResult>();
    private String summary;
    private final int actionCount;
    private final ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;

    @JsonCreator
    public JobExecutionRequestEntity(@JsonProperty(value="jobExecutionRequestId") String jobExecutionRequestId, @JsonProperty(value="revision") String revision, @JsonProperty(value="jobDefinitionId") String jobDefinitionId, @JsonProperty(value="summary") String summary, @JsonProperty(value="actionCount") int actionCount, @JsonProperty(value="jobParameters") JobParameters jobParameters, @JsonProperty(value="results") List<JobActionResult> results, @JsonProperty(value="createdAt") ZonedDateTime createdAt, @JsonProperty(value="updatedAt") ZonedDateTime updatedAt) {
        this.jobExecutionRequestId = jobExecutionRequestId;
        this.revision = revision;
        this.summary = summary;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.actionCount = actionCount;
        this.jobDefinitionId = jobDefinitionId;
        this.jobParameters = jobParameters;
        if (results != null) {
            this.results.addAll(results);
        }
    }

    @CouchId
    public String getJobExecutionRequestId() {
        return this.jobExecutionRequestId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    public List<JobActionResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public void addResult(JobActionResult result) {
        this.results.add(result);
        this.updatedAt = ZonedDateTime.now();
        this.summary = result.isFailure() ? String.format("Action %s of %s failed", this.results.size(), this.actionCount) : String.format("Processed %s of %s actions", this.results.size(), this.actionCount);
    }

    @JsonIgnore
    public Map<String, String> getSubstitutions() {
        return this.jobParameters.getSubstitutions();
    }

    public JobExecutionRequest toJobExecutionRequest() {
        return new JobExecutionRequest(this.jobExecutionRequestId, this.revision, this.jobDefinitionId, this.jobParameters, this.results);
    }

    public static JobExecutionRequestEntity newEntity(JobDefinitionEntity jobDefinition, JobParameters jobParameters) {
        return new JobExecutionRequestEntity(TimeUuid.randomUUID().toString(), null, jobDefinition.getJobDefinitionId(), String.format("Processing %s commands", jobDefinition.getJobActions().size()), jobDefinition.getJobActions().size(), jobParameters, Collections.emptyList(), ZonedDateTime.now(), ZonedDateTime.now());
    }
}

