/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.DOMVisitor;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.util.ArrayUtils;
import org.thymeleaf.util.IdentityCounter;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestableNode
extends Node {
    private static final long serialVersionUID = -5601217853971985055L;
    private static final int DEFAULT_CHILDREN_SIZE = 3;
    private Node[] children = null;
    private int childrenLen = 0;

    NestableNode(String documentName, Integer lineNumber) {
        super(documentName, lineNumber);
    }

    public final boolean hasChildren() {
        return this.childrenLen != 0;
    }

    public final int numChildren() {
        return this.childrenLen;
    }

    public final List<Node> getChildren() {
        if (this.childrenLen == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(ArrayUtils.copyOf(this.children, this.childrenLen));
    }

    public final List<Element> getElementChildren() {
        if (this.childrenLen == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> elementChildren = new ArrayList<Element>(this.childrenLen + 2);
        for (int i = 0; i < this.childrenLen; ++i) {
            if (!(this.children[i] instanceof Element)) continue;
            elementChildren.add((Element)this.children[i]);
        }
        return Collections.unmodifiableList(elementChildren);
    }

    public final Node[] unsafeGetChildrenNodeArray() {
        return this.children;
    }

    public final Node getFirstChild() {
        if (this.childrenLen == 0) {
            return null;
        }
        return this.children[0];
    }

    public final Element getFirstElementChild() {
        if (this.childrenLen == 0) {
            return null;
        }
        for (int i = 0; i < this.childrenLen; ++i) {
            if (!(this.children[i] instanceof Element)) continue;
            return (Element)this.children[i];
        }
        return null;
    }

    public void addChild(Node newChild) {
        if (newChild != null) {
            if (this.childrenLen == 0) {
                this.children = new Node[3];
                this.children[0] = newChild;
                this.childrenLen = 1;
            } else {
                for (int i = 0; i < this.childrenLen; ++i) {
                    if (this.children[i] != newChild) continue;
                    return;
                }
                if (this.childrenLen >= this.children.length) {
                    this.children = ArrayUtils.copyOf(this.children, this.children.length * 2);
                }
                this.children[this.childrenLen++] = newChild;
            }
            newChild.parent = this;
            if (this.getProcessTextNodes()) {
                newChild.setProcessTextNodes(this.getProcessTextNodes());
            }
            if (this.getProcessCommentNodes()) {
                newChild.setProcessCommentNodes(this.getProcessCommentNodes());
            }
        }
    }

    public final void insertChild(int index, Node newChild) {
        Validate.isTrue(index >= 0, "Index for inserting child must be >= 0");
        Validate.isTrue(index <= this.childrenLen, "Index for inserting child must be less or equal than size (" + this.childrenLen + ")");
        if (newChild != null) {
            if (this.childrenLen > 0) {
                for (int i = 0; i < this.childrenLen; ++i) {
                    if (this.children[i] != newChild) continue;
                    if (i == index) {
                        return;
                    }
                    this.unsafeRemoveChild(i);
                    break;
                }
                Validate.isTrue(index <= this.childrenLen, "Index for inserting child must be less or equal than size (" + this.childrenLen + ")");
            }
            if (this.childrenLen == 0) {
                this.children = new Node[3];
                this.children[0] = newChild;
                this.childrenLen = 1;
            } else {
                if (this.childrenLen >= this.children.length) {
                    this.children = ArrayUtils.copyOf(this.children, this.children.length * 2);
                }
                System.arraycopy(this.children, index, this.children, index + 1, this.childrenLen - index);
                this.children[index] = newChild;
                ++this.childrenLen;
            }
            newChild.parent = this;
            if (this.getProcessTextNodes()) {
                newChild.setProcessTextNodes(this.getProcessTextNodes());
            }
            if (this.getProcessCommentNodes()) {
                newChild.setProcessCommentNodes(this.getProcessCommentNodes());
            }
        }
    }

    public final void insertBefore(Node existingChild, Node newChild) {
        for (int i = 0; i < this.childrenLen; ++i) {
            if (this.children[i] != existingChild) continue;
            this.insertChild(i, newChild);
            return;
        }
        throw new IllegalArgumentException("Child does not exist: cannot execute 'insertBefore' operation");
    }

    public final void insertAfter(Node existingChild, Node newChild) {
        for (int i = 0; i < this.childrenLen; ++i) {
            if (this.children[i] != existingChild) continue;
            this.insertChild(i + 1, newChild);
            return;
        }
        throw new IllegalArgumentException("Child does not exist: cannot execute 'insertAfter' operation");
    }

    public final void setChildren(List<Node> newChildren) {
        if (this.children != null) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].parent = null;
            }
            this.children = null;
            this.childrenLen = 0;
        }
        if (newChildren == null || newChildren.size() == 0) {
            this.children = null;
            this.childrenLen = 0;
        } else {
            for (Node newChild : newChildren) {
                this.addChild(newChild);
            }
        }
    }

    public final void clearChildren() {
        if (this.children != null) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].parent = null;
            }
            this.children = null;
            this.childrenLen = 0;
        }
    }

    public final void removeChild(int index) {
        Validate.isTrue(index >= 0, "Index of child to remove must be >= 0");
        Validate.isTrue(index < this.childrenLen, "Index of child to be removed must be less than size (" + this.childrenLen + ")");
        this.unsafeRemoveChild(index);
    }

    final void unsafeRemoveChild(int index) {
        this.children[index].parent = null;
        System.arraycopy(this.children, index + 1, this.children, index, this.childrenLen - (index + 1));
        --this.childrenLen;
    }

    public final void removeChild(Node child) {
        Validate.notNull(child, "Child cannot be null");
        this.unsafeRemoveChild(child);
    }

    final void unsafeRemoveChild(Node child) {
        if (this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                if (this.children[i] != child) continue;
                this.unsafeRemoveChild(i);
                return;
            }
        }
    }

    public final void moveAllChildren(NestableNode newParent) {
        Validate.notNull(newParent, "New parent cannot be null");
        if (this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                newParent.addChild(this.children[i]);
            }
            this.children = null;
            this.childrenLen = 0;
        }
    }

    public final void extractChild(Node child) {
        if (child != null) {
            if (child instanceof NestableNode) {
                NestableNode nestableChild = (NestableNode)child;
                Node.NodeLocalVariablesMap nestableChildNodeLocalVariables = nestableChild.unsafeGetNodeLocalVariables();
                for (int i = 0; i < this.childrenLen; ++i) {
                    if (this.children[i] != nestableChild) continue;
                    this.unsafeRemoveChild(i);
                    for (int j = 0; j < nestableChild.childrenLen; ++j) {
                        this.insertChild(i + j, nestableChild.children[j]);
                        nestableChild.children[j].addAllNonExistingNodeLocalVariables(nestableChildNodeLocalVariables);
                    }
                    return;
                }
            } else {
                this.unsafeRemoveChild(child);
            }
        }
    }

    @Override
    final void doAdditionalPrecomputeNode(Configuration configuration) {
        if (this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].precomputeNode(configuration);
            }
        }
        this.doAdditionalPrecomputeNestableNode(configuration);
    }

    abstract void doAdditionalPrecomputeNestableNode(Configuration var1);

    @Override
    final void doAdditionalSkippableComputing(boolean skippable) {
        if (skippable && this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].setSkippable(true);
            }
        }
    }

    @Override
    final void doAdditionalProcessableComputing(boolean processable) {
        if (!processable && this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].setProcessable(false);
            }
        }
    }

    @Override
    public void setProcessTextNodes(boolean processTextNodes) {
        super.setProcessTextNodes(processTextNodes);
        if (this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].setProcessTextNodes(processTextNodes);
            }
        }
    }

    @Override
    public void setProcessCommentNodes(boolean processCommentNodes) {
        super.setProcessCommentNodes(processCommentNodes);
        if (this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].setProcessCommentNodes(processCommentNodes);
            }
        }
    }

    @Override
    final void doCloneNodeInternals(Node node, NestableNode newParent, boolean cloneProcessors) {
        NestableNode nestableNode = (NestableNode)node;
        if (this.childrenLen > 0) {
            Node[] elementChildren = new Node[this.childrenLen];
            for (int i = 0; i < this.childrenLen; ++i) {
                elementChildren[i] = this.children[i].cloneNode(nestableNode, cloneProcessors);
            }
            nestableNode.children = elementChildren;
            nestableNode.childrenLen = elementChildren.length;
        }
        this.doCloneNestableNodeInternals(nestableNode, newParent, cloneProcessors);
    }

    abstract void doCloneNestableNodeInternals(NestableNode var1, NestableNode var2, boolean var3);

    @Override
    final void doAdditionalProcess(Arguments arguments) {
        if (this.childrenLen > 0) {
            IdentityCounter<Node> alreadyProcessed = new IdentityCounter<Node>(this.childrenLen);
            while (!this.isDetached() && NestableNode.computeNextChild(arguments, this, alreadyProcessed)) {
            }
        }
    }

    private static boolean computeNextChild(Arguments arguments, NestableNode node, IdentityCounter<Node> alreadyProcessed) {
        if (node.childrenLen > 0) {
            for (int i = 0; i < node.childrenLen; ++i) {
                Node child = node.children[i];
                if (alreadyProcessed.isAlreadyCounted(child)) continue;
                child.processNode(arguments);
                alreadyProcessed.count(child);
                return true;
            }
        }
        return false;
    }

    @Override
    public final void visit(DOMVisitor visitor) {
        visitor.visit(this);
        if (this.childrenLen > 0) {
            for (int i = 0; i < this.childrenLen; ++i) {
                this.children[i].visit(visitor);
            }
        }
    }
}

