/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tiogasolutions.dev.common.IoUtils;
import org.tiogasolutions.dev.common.ReflectUtils;
import org.tiogasolutions.dev.common.exceptions.ApiException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.domain.query.ListQueryResult;
import org.tiogasolutions.dev.domain.query.QueryResult;
import org.tiogasolutions.jobs.agent.JobsApplication;
import org.tiogasolutions.jobs.agent.entities.JobDefinitionEntity;
import org.tiogasolutions.jobs.agent.entities.JobDefinitionStore;
import org.tiogasolutions.jobs.agent.entities.JobExecutionRequestEntity;
import org.tiogasolutions.jobs.agent.entities.JobExecutionRequestStore;
import org.tiogasolutions.jobs.agent.resources.JobVariable;
import org.tiogasolutions.jobs.pub.ActionType;
import org.tiogasolutions.jobs.pub.JobAction;
import org.tiogasolutions.jobs.pub.JobActionResult;
import org.tiogasolutions.jobs.pub.JobDefinition;
import org.tiogasolutions.jobs.pub.JobExecutionRequest;
import org.tiogasolutions.jobs.pub.JobParameters;

public class JobsResourceV1 {
    private static final Log log = LogFactory.getLog(JobsResourceV1.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    @GET
    @Produces(value={"application/json"})
    public QueryResult<JobDefinition> getJobs(@Context Application app) {
        ArrayList jobDefinitions = new ArrayList();
        JobsApplication.get(app, JobDefinitionStore.class).getAll().stream().forEach(jobEntity -> jobDefinitions.add(jobEntity.toJobDefinition()));
        return ListQueryResult.newComplete(JobDefinition.class, jobDefinitions);
    }

    private JobDefinitionEntity loadJob(Application app, String jobDefinitionId) {
        JobDefinitionStore store = JobsApplication.get(app, JobDefinitionStore.class);
        JobDefinitionEntity jobDefinitionEntity = (JobDefinitionEntity)store.getByDocumentId(jobDefinitionId);
        if (jobDefinitionEntity == null) {
            String msg = String.format("The job definition \"%s\" does not exist.", jobDefinitionId);
            throw ApiNotFoundException.notFound((String)msg, (String[])new String[0]);
        }
        return jobDefinitionEntity;
    }

    @GET
    @Path(value="/{jobDefinitionId}")
    @Produces(value={"application/json"})
    public JobDefinition getJob(@Context Application app, @PathParam(value="jobDefinitionId") String jobDefinitionId) throws Exception {
        return this.loadJob(app, jobDefinitionId).toJobDefinition();
    }

    @POST
    @Path(value="/{jobDefinitionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobExecutionRequest execute(@Context Application app, @Context UriInfo uriInfo, @PathParam(value="jobDefinitionId") String jobDefinitionId, JobParameters jobParameters) throws Exception {
        return this.execute(app, uriInfo, jobDefinitionId, -1, jobParameters);
    }

    @POST
    @Path(value="/{jobDefinitionId}/commands/{commandIndex}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JobExecutionRequest execute(@Context Application app, @Context UriInfo uriInfo, @PathParam(value="jobDefinitionId") String jobDefinitionId, @PathParam(value="commandIndex") int commandIndex, JobParameters jobParameters) throws Exception {
        if (jobParameters == null) {
            throw ApiException.badRequest((String)"The job parameters must be specified.", (String[])new String[0]);
        }
        JobDefinitionEntity jobDefinitionEntity = this.loadJob(app, jobDefinitionId);
        JobExecutionRequestEntity request = JobExecutionRequestEntity.newEntity(jobDefinitionEntity, jobParameters);
        JobsApplication.get(app, JobExecutionRequestStore.class).create(request);
        if (jobParameters.isSynchronous()) {
            return this.executeJob(app, request, jobDefinitionEntity, commandIndex);
        }
        executor.submit(() -> this.executeJob(app, request, jobDefinitionEntity, commandIndex));
        return request.toJobExecutionRequest();
    }

    private JobExecutionRequest executeJob(Application app, JobExecutionRequestEntity request, JobDefinitionEntity jobDefinitionEntity, int commandIndex) throws Exception {
        List<JobAction> actions = jobDefinitionEntity.getJobActions();
        if (commandIndex >= 0) {
            actions = Collections.singletonList(actions.get(commandIndex));
        }
        for (JobAction jobAction : actions) {
            if (this.processAction(app, request, jobAction).isFailure()) break;
        }
        JobsApplication.get(app, JobExecutionRequestStore.class).update(request);
        return request.toJobExecutionRequest();
    }

    private JobActionResult processAction(Application app, JobExecutionRequestEntity request, JobAction jobAction) throws Exception {
        ActionType actionType = jobAction.getActionType();
        if (actionType.isOsCommand()) {
            return this.processOsCommand(app, request, jobAction);
        }
        String msg = String.format("The action type \"%s\" is not supported.", actionType);
        throw new UnsupportedOperationException(msg);
    }

    private JobActionResult processOsCommand(Application app, JobExecutionRequestEntity request, JobAction jobAction) {
        JobActionResult result;
        String command = jobAction.getCommand();
        try {
            JobVariable variable = JobVariable.findFirst(command);
            while (variable != null) {
                command = variable.replace(request.getSubstitutions(), command);
                variable = JobVariable.findFirst(command);
            }
            List<String> commands = JobsResourceV1.splitCommand(command);
            String[] commandArray = (String[])ReflectUtils.toArray(String.class, commands);
            File workingDir = jobAction.getWorkingDirectory();
            if (!workingDir.exists()) {
                String msg = "The specified working directory does not exist: " + workingDir.getAbsolutePath();
                throw new FileNotFoundException(msg);
            }
            File outFile = File.createTempFile("process-out-", ".txt");
            outFile.deleteOnExit();
            File errFile = File.createTempFile("process-err-", ".txt");
            errFile.deleteOnExit();
            Process process = new ProcessBuilder(new String[0]).command(commandArray).directory(workingDir).redirectOutput(ProcessBuilder.Redirect.to(outFile)).redirectError(ProcessBuilder.Redirect.to(errFile)).start();
            process.waitFor(jobAction.getTimeout(), jobAction.getTimeoutUnit());
            if (process.isAlive()) {
                process.destroyForcibly();
            }
            int exitValue = process.exitValue();
            String out = IoUtils.toString((File)outFile);
            if (!outFile.delete()) {
                log.warn((Object)("Unable to delete temp file: " + outFile.getAbsolutePath()));
            }
            String err = IoUtils.toString((File)errFile);
            if (!errFile.delete()) {
                log.warn((Object)("Unable to delete temp file: " + errFile.getAbsolutePath()));
            }
            result = JobActionResult.finished((String)command, (int)exitValue, (String)out, (String)err);
        }
        catch (Exception ex) {
            result = JobActionResult.fail((String)command, (Exception)ex);
        }
        request.addResult(result);
        JobsApplication.get(app, JobExecutionRequestStore.class).update(request);
        return result;
    }

    public static List<String> splitCommand(String command) {
        boolean inString = false;
        ArrayList<String> commands = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (char chr : command.toCharArray()) {
            if (inString) {
                if (chr != '\"') {
                    builder.append(chr);
                    continue;
                }
                inString = false;
                JobsResourceV1.finish(builder, commands);
                continue;
            }
            if (chr == '\"') {
                inString = true;
                continue;
            }
            if (Character.isWhitespace(chr)) {
                JobsResourceV1.finish(builder, commands);
                continue;
            }
            builder.append(chr);
        }
        JobsResourceV1.finish(builder, commands);
        return commands;
    }

    private static void finish(StringBuilder builder, List<String> commands) {
        if (builder.length() > 0) {
            commands.add(builder.toString());
        }
        builder.delete(0, builder.length());
    }
}

