/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.thymeleaf.util.EvaluationUtil;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class DateUtils {
    private static final Map<DateFormatKey, DateFormat> dateFormats = new ConcurrentHashMap<DateFormatKey, DateFormat>();

    public static Calendar create(Object year, Object month, Object day) {
        return DateUtils.create(year, month, day, null, null, null, null, null, null);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute) {
        return DateUtils.create(year, month, day, hour, minute, null, null, null, null);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second) {
        return DateUtils.create(year, month, day, hour, minute, second, null, null, null);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond) {
        return DateUtils.create(year, month, day, hour, minute, second, millisecond, null, null);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond, Object timeZone) {
        return DateUtils.create(year, month, day, hour, minute, second, millisecond, timeZone, null);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond, Object timeZone, Locale locale) {
        TimeZone tzTimeZone;
        BigDecimal nMillisecond;
        BigDecimal nYear = year == null ? null : EvaluationUtil.evaluateAsNumber(year);
        BigDecimal nMonth = month == null ? null : EvaluationUtil.evaluateAsNumber(month);
        BigDecimal nDay = day == null ? null : EvaluationUtil.evaluateAsNumber(day);
        BigDecimal nHour = hour == null ? null : EvaluationUtil.evaluateAsNumber(hour);
        BigDecimal nMinute = minute == null ? null : EvaluationUtil.evaluateAsNumber(minute);
        BigDecimal nSecond = second == null ? null : EvaluationUtil.evaluateAsNumber(second);
        BigDecimal bigDecimal = nMillisecond = millisecond == null ? null : EvaluationUtil.evaluateAsNumber(millisecond);
        TimeZone timeZone2 = timeZone != null ? (timeZone instanceof TimeZone ? (TimeZone)timeZone : TimeZone.getTimeZone(timeZone.toString())) : (tzTimeZone = null);
        Calendar cal = tzTimeZone != null && locale != null ? Calendar.getInstance(tzTimeZone, locale) : (tzTimeZone != null ? Calendar.getInstance(tzTimeZone) : (locale != null ? Calendar.getInstance(locale) : Calendar.getInstance()));
        if (nYear == null || nMonth == null || nDay == null) {
            throw new IllegalArgumentException("Cannot create Calendar/Date object with null year (" + nYear + "), " + "month (" + nMonth + ") or day (" + nDay + ")");
        }
        cal.set(1, nYear.intValue());
        cal.set(2, nMonth.intValue() - 1);
        cal.set(5, nDay.intValue());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (nHour != null && nMinute != null) {
            cal.set(11, nHour.intValue());
            cal.set(12, nMinute.intValue());
            if (nSecond != null) {
                cal.set(13, nSecond.intValue());
                if (nMillisecond != null) {
                    cal.set(14, nMillisecond.intValue());
                }
            } else if (nMillisecond != null) {
                throw new IllegalArgumentException("Calendar/Date object cannot be correctly created from a null second but non-null millisecond.");
            }
        } else {
            if (nHour != null || nMinute != null) {
                throw new IllegalArgumentException("Calendar/Date object can only be correctly created if hour (" + nHour + ") " + "and minute (" + nMinute + ") are either both null or non-null.");
            }
            if (nSecond != null || nMillisecond != null) {
                throw new IllegalArgumentException("Calendar/Date object cannot be correctly created from a null hour and minute but non-null second and/or millisecond.");
            }
        }
        return cal;
    }

    public static Calendar createNow() {
        return DateUtils.createNow(null, null);
    }

    public static Calendar createNow(Object timeZone) {
        return DateUtils.createNow(timeZone, null);
    }

    public static Calendar createNow(Object timeZone, Locale locale) {
        TimeZone tzTimeZone;
        TimeZone timeZone2 = timeZone != null ? (timeZone instanceof TimeZone ? (TimeZone)timeZone : TimeZone.getTimeZone(timeZone.toString())) : (tzTimeZone = null);
        if (tzTimeZone != null && locale != null) {
            return Calendar.getInstance(tzTimeZone, locale);
        }
        if (tzTimeZone != null) {
            return Calendar.getInstance(tzTimeZone);
        }
        if (locale != null) {
            return Calendar.getInstance(locale);
        }
        return Calendar.getInstance();
    }

    public static Calendar createToday() {
        return DateUtils.createToday(null, null);
    }

    public static Calendar createToday(Object timeZone) {
        return DateUtils.createToday(timeZone, null);
    }

    public static Calendar createToday(Object timeZone, Locale locale) {
        Calendar cal = DateUtils.createNow(timeZone, locale);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal;
    }

    public static String format(Object target, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        return DateUtils.formatDate(target, locale);
    }

    public static String format(Object target, String pattern, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notEmpty(pattern, "Pattern cannot be null or empty");
        return DateUtils.formatDate(target, pattern, locale);
    }

    public static Integer day(Object target) {
        Validate.notNull(target, "Cannot retrieve day from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(5);
    }

    public static Integer month(Object target) {
        Validate.notNull(target, "Cannot retrieve month from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(2) + 1;
    }

    public static String monthName(Object target, Locale locale) {
        Validate.notNull(target, "Cannot retrieve month name from null");
        return DateUtils.format(target, "MMMM", locale);
    }

    public static String monthNameShort(Object target, Locale locale) {
        Validate.notNull(target, "Cannot retrieve month name short from null");
        return DateUtils.format(target, "MMM", locale);
    }

    public static Integer year(Object target) {
        Validate.notNull(target, "Cannot retrieve year from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(1);
    }

    public static Integer dayOfWeek(Object target) {
        Validate.notNull(target, "Cannot retrieve day of week from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(7);
    }

    public static String dayOfWeekName(Object target, Locale locale) {
        Validate.notNull(target, "Cannot retrieve day of week name from null");
        return DateUtils.format(target, "EEEE", locale);
    }

    public static String dayOfWeekNameShort(Object target, Locale locale) {
        Validate.notNull(target, "Cannot retrieve day of week name shortfrom null");
        return DateUtils.format(target, "EEE", locale);
    }

    public static Integer hour(Object target) {
        Validate.notNull(target, "Cannot retrieve hour from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(11);
    }

    public static Integer minute(Object target) {
        Validate.notNull(target, "Cannot retrieve hour from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(12);
    }

    public static Integer second(Object target) {
        Validate.notNull(target, "Cannot retrieve hour from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(13);
    }

    public static Integer millisecond(Object target) {
        Validate.notNull(target, "Cannot retrieve hour from null");
        Calendar cal = DateUtils.normalizeDate(target);
        return cal.get(14);
    }

    private static Calendar normalizeDate(Object target) {
        if (target instanceof Calendar) {
            return (Calendar)target;
        }
        if (target instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Date)target).getTime());
            return cal;
        }
        throw new IllegalArgumentException("Cannot normalize class \"" + target.getClass().getName() + "\" as a date");
    }

    private static String formatDate(Object target, Locale locale) {
        return DateUtils.formatDate(target, null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatDate(Object target, String pattern, Locale locale) {
        Validate.notNull(target, "Cannot apply format on null");
        Validate.notNull(locale, "Locale cannot be null");
        DateFormatKey key = new DateFormatKey(target, pattern, locale);
        DateFormat dateFormat = dateFormats.get(key);
        if (dateFormat == null) {
            dateFormat = StringUtils.isEmptyOrWhitespace(pattern) ? DateFormat.getDateTimeInstance(1, 1, locale) : new SimpleDateFormat(pattern, locale);
            if (key.timeZone != null) {
                dateFormat.setTimeZone(key.timeZone);
            }
            dateFormats.put(key, dateFormat);
        }
        if (target instanceof Calendar) {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                return dateFormat.format(((Calendar)target).getTime());
            }
        }
        if (target instanceof Date) {
            DateFormat dateFormat3 = dateFormat;
            synchronized (dateFormat3) {
                return dateFormat.format((Date)target);
            }
        }
        throw new IllegalArgumentException("Cannot format object of class \"" + target.getClass().getName() + "\" as a date");
    }

    private DateUtils() {
    }

    private static final class DateFormatKey {
        final String format;
        final TimeZone timeZone;
        final Locale locale;

        DateFormatKey(Object target, String format, Locale locale) {
            Validate.notNull(locale, "Locale cannot be null");
            this.format = format;
            this.locale = locale;
            this.timeZone = target != null && target instanceof Calendar ? ((Calendar)target).getTimeZone() : null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
            result = 31 * result + this.locale.hashCode();
            result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateFormatKey other = (DateFormatKey)obj;
            if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
                return false;
            }
            if (this.timeZone == null ? other.timeZone != null : !this.timeZone.equals(other.timeZone)) {
                return false;
            }
            return this.locale.equals(other.locale);
        }
    }
}

