/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.couchace.core.api.response;

import java.net.URI;
import org.tiogasolutions.couchace.core.api.http.CouchHttpStatus;
import org.tiogasolutions.couchace.core.api.http.CouchMediaType;
import org.tiogasolutions.couchace.core.api.http.CouchMethodType;
import org.tiogasolutions.couchace.core.api.response.CouchErrorContent;
import org.tiogasolutions.couchace.core.api.response.CouchResponse;
import org.tiogasolutions.couchace.core.internal.util.ArgUtil;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpResponse;

public class HeadResponse
implements CouchResponse {
    private final URI uri;
    private final CouchHttpStatus httpStatus;
    private final CouchMediaType contentType;
    private final String documentId;
    private final String documentRevision;

    public HeadResponse(CouchHttpResponse response) {
        this(response.getUri(), response.getHttpStatus(), response.getContentType(), response.getDocumentId(), response.getEtag());
    }

    public HeadResponse(URI uri, CouchHttpStatus httpStatus, CouchMediaType contentType, String documentId, String documentRevision) {
        ArgUtil.assertNotNull(uri, "URI");
        ArgUtil.assertNotNull((Object)httpStatus, "HttpStatus");
        this.uri = uri;
        this.httpStatus = httpStatus;
        this.contentType = contentType != null ? contentType : CouchMediaType.UNDEFINED;
        this.documentId = documentId;
        this.documentRevision = documentRevision;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentRevision() {
        return this.documentRevision;
    }

    public boolean hasDocumentRevision() {
        return this.documentRevision != null;
    }

    @Override
    public CouchMediaType getContentType() {
        return this.contentType;
    }

    @Override
    public CouchMethodType getMethodType() {
        return CouchMethodType.HEAD;
    }

    @Override
    public CouchHttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public int getHttpStatusCode() {
        return this.httpStatus.getCode();
    }

    @Override
    public boolean isOk() {
        return this.httpStatus.isOk();
    }

    @Override
    public boolean isNotFound() {
        return this.httpStatus.isNotFound();
    }

    @Override
    public boolean isUnauthorized() {
        return this.httpStatus.isUnauthorized();
    }

    @Override
    public boolean isSuccess() {
        return this.httpStatus == CouchHttpStatus.CREATED || this.httpStatus == CouchHttpStatus.OK;
    }

    @Override
    public boolean isError() {
        return this.httpStatus != CouchHttpStatus.CREATED && this.httpStatus != CouchHttpStatus.OK;
    }

    @Override
    public boolean isCreated() {
        return this.httpStatus.isCreated();
    }

    @Override
    public boolean isConflict() {
        return this.httpStatus.isConflict();
    }

    @Override
    public CouchErrorContent getErrorContent() {
        return CouchErrorContent.noError;
    }

    @Override
    public String getErrorReason() {
        return CouchErrorContent.noError.getReason();
    }
}

