/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class OffsetTimeSerializer
extends JSR310FormattedSerializerBase<OffsetTime> {
    private static final long serialVersionUID = 1L;
    public static final OffsetTimeSerializer INSTANCE = new OffsetTimeSerializer();

    private OffsetTimeSerializer() {
        this(null, null);
    }

    private OffsetTimeSerializer(Boolean useTimestamp, DateTimeFormatter dtf) {
        super(OffsetTime.class, useTimestamp, dtf);
    }

    protected OffsetTimeSerializer withFormat(Boolean useTimestamp, DateTimeFormatter dtf) {
        return new OffsetTimeSerializer(useTimestamp, dtf);
    }

    public void serialize(OffsetTime time, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            generator.writeStartArray();
            generator.writeNumber(time.getHour());
            generator.writeNumber(time.getMinute());
            if (time.getSecond() > 0 || time.getNano() > 0) {
                generator.writeNumber(time.getSecond());
                if (time.getNano() > 0) {
                    if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        generator.writeNumber(time.getNano());
                    } else {
                        generator.writeNumber(time.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            generator.writeString(time.getOffset().toString());
            generator.writeEndArray();
        } else {
            String str = this._formatter == null ? time.toString() : time.format(this._formatter);
            generator.writeString(str);
        }
    }
}

