/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.couchace;

import com.fasterxml.jackson.databind.Module;
import org.tiogasolutions.couchace.core.api.CouchServer;
import org.tiogasolutions.couchace.core.api.CouchSetup;
import org.tiogasolutions.couchace.core.api.http.CouchHttpException;
import org.tiogasolutions.couchace.core.spi.http.CouchHttpClient;
import org.tiogasolutions.couchace.core.spi.json.CouchJsonStrategy;
import org.tiogasolutions.couchace.jackson.JacksonCouchJsonStrategy;
import org.tiogasolutions.couchace.jersey.JerseyCouchHttpClient;
import org.tiogasolutions.dev.common.EnvUtils;
import org.tiogasolutions.dev.jackson.TiogaJacksonModule;

public class DefaultCouchServer
extends CouchServer {
    public DefaultCouchServer(CouchSetup couchSetup) {
        super(couchSetup);
        this.validateConnection(couchSetup);
    }

    public DefaultCouchServer() {
        this(new CouchSetup(DefaultCouchServer.getAppUrl()).setUserName(DefaultCouchServer.getAppUserName()).setPassword(DefaultCouchServer.getAppPassword()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)new JacksonCouchJsonStrategy(new Module[]{new TiogaJacksonModule()})));
    }

    public DefaultCouchServer(Module[] modules) {
        this(new CouchSetup(DefaultCouchServer.getAppUrl()).setUserName(DefaultCouchServer.getAppUserName()).setPassword(DefaultCouchServer.getAppPassword()).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)new JacksonCouchJsonStrategy(modules)));
    }

    public DefaultCouchServer(CouchHttpClient couchHttpClient, CouchJsonStrategy couchJsonStrategy) {
        this(new CouchSetup(DefaultCouchServer.getAppUrl()).setUserName(DefaultCouchServer.getAppUserName()).setPassword(DefaultCouchServer.getAppPassword()).setHttpClient(couchHttpClient).setJsonStrategy(couchJsonStrategy));
    }

    public DefaultCouchServer(CouchHttpClient couchHttpClient, CouchJsonStrategy couchJsonStrategy, String url, String userName, String password) {
        this(new CouchSetup(url).setUserName(userName).setPassword(password).setHttpClient(couchHttpClient).setJsonStrategy(couchJsonStrategy));
    }

    public void validateConnection(CouchSetup couchSetup) {
        try {
            this.assertConnection();
        }
        catch (CouchHttpException e) {
            String msg = String.format("Unable to verify connection for %s at %s.", couchSetup.getUserName(), couchSetup.getUrl());
            throw new CouchHttpException(e.getHttpStatus(), msg);
        }
    }

    public static String getAppPassword() {
        String userName = DefaultCouchServer.getAppUserName();
        return EnvUtils.findProperty((String)"app.couch.password", (String)userName);
    }

    public static String getAppUserName() {
        return EnvUtils.findProperty((String)"app.couch.userName", (String)"app-user");
    }

    public static String getAppUrl() {
        return EnvUtils.findProperty((String)"app.couch.url", (String)"http://localhost:5984");
    }
}

