/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.jobs.agent.support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.DatatypeConverter;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.dev.common.exceptions.ExceptionUtils;
import org.tiogasolutions.jobs.agent.JobsApplication;
import org.tiogasolutions.jobs.agent.entities.DomainProfileEntity;
import org.tiogasolutions.jobs.agent.entities.DomainProfileStore;
import org.tiogasolutions.jobs.agent.support.ExecutionContextManager;

@PreMatching
@Priority(value=1000)
public class JobsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private UriInfo uriInfo;
    private Application app;

    @Context
    private void init(Application app, UriInfo uriInfo) {
        this.app = app;
        this.uriInfo = uriInfo;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String baseUri = this.uriInfo.getBaseUri().toString();
        String requestUri = this.uriInfo.getRequestUri().toString();
        String path = requestUri.substring(baseUri.length() - 1);
        Map properties = this.app.getProperties();
        String clientContext = ExceptionUtils.assertNotZeroLength((String)((String)properties.get("app.client.context")), (String)"app.client.context");
        String adminContext = ExceptionUtils.assertNotZeroLength((String)((String)properties.get("app.admin.context")), (String)"app.admin.context");
        if (path.equals(clientContext) || path.startsWith(clientContext + "/")) {
            this.authenticateClientRequest(requestContext);
        } else if (path.equals(adminContext) || path.startsWith(adminContext + "/")) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        JobsApplication.get(this.app, ExecutionContextManager.class).clearContext();
    }

    private void authenticateClientRequest(ContainerRequestContext requestContext) {
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            throw new NotAuthorizedException((Object)"Notify", new Object[0]);
        }
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)(authHeader = authHeader.substring(6)));
        String basicAuth = new String(bytes, StandardCharsets.UTF_8);
        int pos = basicAuth.indexOf(":");
        if (pos < 0) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        String apiUsername = basicAuth.substring(0, pos);
        String apiPassword = basicAuth.substring(pos + 1);
        if (StringUtils.isBlank((Object)apiUsername) || StringUtils.isBlank((Object)apiPassword)) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        DomainProfileStore store = (DomainProfileStore)((Object)this.app.getProperties().get(DomainProfileStore.class.getName()));
        DomainProfileEntity domainProfile = store.getByApiKey(apiUsername);
        if (domainProfile == null) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        if (EqualsUtils.objectsNotEqual((Object)apiPassword, (Object)domainProfile.getApiPassword())) {
            throw new NotAuthorizedException((Object)"API", new Object[0]);
        }
        JobsApplication.get(this.app, ExecutionContextManager.class).create(domainProfile);
    }
}

